/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.bean.HttpRequestUtilBean;
import com.cxqm.xiaoerke.common.utils.MyX509TrustManager;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpStatus;

public class HttpRequestUtil {
    public static String get(String url) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpResponse resp = client.execute((HttpUriRequest)httpGet);
        HttpEntity entity = resp.getEntity();
        String respContent = EntityUtils.toString((HttpEntity)entity, (String)"utf-8").trim();
        httpGet.abort();
        client.getConnectionManager().shutdown();
        return respContent;
    }

    public static int post(String url, String content) throws IOException {
        try {
            return HttpRequestUtil.publicPost(url, content).getCode();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 500;
        }
    }

    public static HttpRequestUtilBean publicPost(String url, String content) throws IOException {
        return HttpRequestUtil.publicPost(url, content, false);
    }

    public static HttpRequestUtilBean publicPost(String url, String content, boolean contentByForm) throws IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(url);
        try {
            JSONObject jasonObject;
            if (contentByForm) {
                httppost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            }
            httppost.setEntity((HttpEntity)new StringEntity(content, "utf-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpRequestUtilBean bean = new HttpRequestUtilBean();
            JSONObject map = jasonObject = JSONObject.fromObject((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
            bean.setContent(map.toString());
            if (!map.get("resultCode").equals("0")) {
                bean.setCode(500);
            } else {
                bean.setCode(response.getStatusLine().getStatusCode());
            }
            return bean;
        }
        catch (IOException e) {
            e.printStackTrace();
            HttpRequestUtilBean bean = new HttpRequestUtilBean();
            bean.setCode(500);
            return bean;
        }
    }

    public static org.json.JSONObject postByJson(String url, String json) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(url);
        org.json.JSONObject response = null;
        try {
            StringEntity s = new StringEntity(json.toString());
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json");
            post.setEntity((HttpEntity)s);
            HttpResponse res = client.execute((HttpUriRequest)post);
            if (res.getStatusLine().getStatusCode() == HttpStatus.OK.value()) {
                HttpEntity entity = res.getEntity();
                InputStream is = entity.getContent();
                if (entity != null) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        System.out.println(line);
                    }
                    is.close();
                    response = new org.json.JSONObject(line);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public static String httpPost(String postData, String postUrl) {
        try {
            String line;
            URL url = new URL(postUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Length", "" + postData.length());
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(postData);
            out.flush();
            out.close();
            if (conn.getResponseCode() != 200) {
                System.out.println("connect failed!");
                return "";
            }
            String result = "";
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            while ((line = in.readLine()) != null) {
                result = result + line + "\n";
            }
            in.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return "";
        }
    }

    public static String getConnectionResult(String urlPath, String method, String content) {
        try {
            URL url = new URL(urlPath);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method.toUpperCase());
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setReadTimeout(10000);
            if ("GET".equalsIgnoreCase(method)) {
                connection.connect();
            }
            if (!content.isEmpty()) {
                OutputStream os = connection.getOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(os);
                bos.write(content.getBytes("utf-8"));
                bos.close();
            }
            InputStream is = connection.getInputStream();
            String str = "";
            StringBuffer outputValue = new StringBuffer();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
            while ((str = br.readLine()) != null) {
                outputValue.append(str);
                outputValue.append("\n");
            }
            br.close();
            String result = outputValue.toString();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String httpsRequest(String requestUrl, String requestMethod, String outputStr) {
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setSSLSocketFactory(ssf);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(requestMethod);
            conn.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            if (null != outputStr) {
                OutputStream outputStream = conn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = conn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            StringBuffer buffer = new StringBuffer();
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            conn.disconnect();
            return buffer.toString();
        }
        catch (ConnectException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String wechatpost(String strURL, String params) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            out.append(params);
            out.flush();
            out.close();
            int length = connection.getContentLength();
            InputStream is = connection.getInputStream();
            if (length != -1) {
                byte[] data = new byte[length];
                byte[] temp = new byte[512];
                int readLen = 0;
                int destPos = 0;
                while ((readLen = is.read(temp)) > 0) {
                    System.arraycopy(temp, 0, data, destPos, readLen);
                    destPos += readLen;
                }
                String result = new String(data, "UTF-8");
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=TOKEN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clientCustomSSLS(String p12fileName, String keyPassword, String url, String postDate) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        URL resource = HttpRequestUtil.class.getResource("/" + p12fileName);
        File file = resource == null ? new File(System.getProperty("user.dir") + "/" + p12fileName) : new File(URLDecoder.decode(resource.getPath(), "utf-8"));
        try (FileInputStream instream = new FileInputStream(file);){
            keyStore.load(instream, keyPassword.toCharArray());
        }
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, keyPassword.toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        try (CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();){
            HttpPost httpPost = new HttpPost(url);
            StringEntity requestEntity = new StringEntity(postDate, "utf-8");
            requestEntity.setContentType("application/x-www-form-urlencoded");
            httpPost.setEntity((HttpEntity)requestEntity);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                HttpEntity responseEntity = response.getEntity();
                if (responseEntity != null) {
                    String text;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(responseEntity.getContent(), "utf-8"));
                    StringBuffer sbuf = new StringBuffer();
                    while ((text = bufferedReader.readLine()) != null) {
                        sbuf.append(text);
                    }
                    String string = sbuf.toString();
                    return string;
                }
                EntityUtils.consume((HttpEntity)responseEntity);
            }
        }
        return "";
    }
}

