/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.utils.OSSObjectTool;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImgUtils {
    private static String zhPattern = "[\u4e00-\u9fa5]";

    public static void composePic(String headUrl, String codeUrl, String outSrc, int width, int height, int width1, int height1) {
        String fileSrc = "http://xiaoerke-article-pic.oss-cn-beijing.aliyuncs.com/olympicBaby_inviteBaseImg.png";
        try {
            URL url = new URL(fileSrc);
            HttpURLConnection httpUrl = (HttpURLConnection)url.openConnection();
            BufferedImage bg_src = ImageIO.read(httpUrl.getInputStream());
            Image logo_src = ImgUtils.getRoundImage(headUrl);
            Image code_src = ImgUtils.cutImage(codeUrl, 25, 25, 380, 380);
            int bg_width = ((Image)bg_src).getWidth(null);
            int bg_height = ((Image)bg_src).getHeight(null);
            BufferedImage tag = new BufferedImage(bg_width, bg_height, 1);
            Graphics2D g2d = tag.createGraphics();
            g2d.drawImage(bg_src, 0, 0, bg_width, bg_height, null);
            g2d.setComposite(AlphaComposite.getInstance(10, 1.0f));
            g2d.drawImage(logo_src, width, height, 126, 126, null);
            g2d.drawImage(code_src, width1, height1, 215, 215, null);
            g2d.setComposite(AlphaComposite.getInstance(3));
            FileOutputStream out = new FileOutputStream(outSrc);
            ImageIO.write((RenderedImage)tag, "png", out);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Image cutImage(String src, int x, int y, int w, int h) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("jpg");
        ImageReader reader = iterator.next();
        URL url = new URL(src);
        HttpURLConnection httpUrl = (HttpURLConnection)url.openConnection();
        InputStream in = httpUrl.getInputStream();
        ImageInputStream iis = ImageIO.createImageInputStream(in);
        reader.setInput(iis, true);
        ImageReadParam param = reader.getDefaultReadParam();
        Rectangle rect = new Rectangle(x, y, w, h);
        param.setSourceRegion(rect);
        BufferedImage bi = reader.read(0, param);
        return bi;
    }

    public static Image getRoundImage(String headUrl) throws Exception {
        BufferedImage logo_src;
        URL url1 = new URL(headUrl);
        HttpURLConnection httpUrl1 = (HttpURLConnection)url1.openConnection();
        BufferedImage bi1 = logo_src = ImageIO.read(httpUrl1.getInputStream());
        BufferedImage bi2 = new BufferedImage(bi1.getWidth(), bi1.getHeight(), 1);
        Graphics2D g2 = bi2.createGraphics();
        bi2 = g2.getDeviceConfiguration().createCompatibleImage(bi1.getWidth(), bi1.getHeight(), 3);
        g2.dispose();
        g2 = bi2.createGraphics();
        Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, bi1.getWidth(), bi1.getHeight());
        g2.setBackground(Color.red);
        g2.draw(new Rectangle(bi2.getWidth(), bi2.getHeight()));
        g2.setClip(shape);
        g2.drawImage((Image)bi1, 0, 0, null);
        g2.dispose();
        return bi2;
    }

    public static Boolean existHttpPath(String httpPath) {
        URL httpurl = null;
        try {
            httpurl = new URL(httpPath);
            URLConnection rulConnection = httpurl.openConnection();
            rulConnection.getInputStream();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void uploadImage(String id, String path) {
        try {
            File file = new File(URLDecoder.decode(path, "utf-8"));
            FileInputStream inputStream = new FileInputStream(file);
            long length = file.length();
            OSSObjectTool.uploadFileInputStream(id, length, inputStream, OSSObjectTool.BUCKET_ARTICLE_PIC);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }

    public static String encode(String str, String charset) throws UnsupportedEncodingException {
        Pattern p = Pattern.compile(zhPattern);
        Matcher m = p.matcher(str);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(b, URLEncoder.encode(m.group(0), charset));
        }
        m.appendTail(b);
        return b.toString();
    }
}

