/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.junit.AssertEx;
import com.cxqm.xiaoerke.common.persistence.Page;
import java.util.HashMap;
import java.util.Map;

public class ResponseMapBuilder {
    public static final String KEY_RESULTCODE = "resultCode";
    public static final String KEY_RESULTMSG = "resultMsg";
    private Map<String, Object> result;

    public static ResponseMapBuilder emptyBuilder() {
        ResponseMapBuilder builder = new ResponseMapBuilder();
        return builder;
    }

    public static ResponseMapBuilder newBuilder() {
        ResponseMapBuilder builder = new ResponseMapBuilder();
        builder.result = new HashMap<String, Object>();
        return builder;
    }

    public static ResponseMapBuilder newBuilder(Map<String, Object> result) {
        ResponseMapBuilder builder = new ResponseMapBuilder();
        builder.result = result;
        return builder;
    }

    private ResponseMapBuilder() {
    }

    public Map<String, Object> getResult() {
        return this.result;
    }

    public void setResult(Map<String, Object> result) {
        this.result = result;
    }

    public ResponseMapBuilder putSuccess() {
        AssertEx.assertNotNull(this.result);
        this.put(KEY_RESULTCODE, "0");
        this.put(KEY_RESULTMSG, "");
        return this;
    }

    public ResponseMapBuilder putPageInfo(Page page4api) {
        Map<String, Object> page = ResponseMapBuilder.newBuilder().put("pageNo", page4api.getPageNo()).put("pageSize", page4api.getPageSize()).put("count", page4api.getCount()).put("prev", page4api.getPrev()).put("next", page4api.getNext()).put("firstPage", page4api.isFirstPage() ? 1 : 0).put("lastPage", page4api.isLastPage() ? 1 : 0).put("data", page4api.getList()).getResult();
        this.put("result", page);
        return this;
    }

    public ResponseMapBuilder put(String property, Object value) {
        this.result.put(property, value);
        return this;
    }
}

