/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.web;

import com.alibaba.fastjson.JSONObject;
import com.cxqm.xiaoerke.common.bean.HttpRequestUtilBean;
import com.cxqm.xiaoerke.common.persistence.Page;
import com.cxqm.xiaoerke.common.utils.ApiInvokerException;
import com.cxqm.xiaoerke.common.utils.HttpRequestUtil;
import com.cxqm.xiaoerke.common.web.ApiValidateInterceptor;
import com.cxqm.xiaoerke.common.web.ApiValidateTokenVo;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class ApiInvoker
implements Serializable {
    private static final long serialVersionUID = 1844198524983377043L;
    private String baseUrl;
    private String primaryKey;

    public ApiInvokerException validateResult(JSONObject jsonObject) {
        if (jsonObject == null) {
            return new ApiInvokerException();
        }
        String resultCode = jsonObject.getString("resultCode");
        String resultMsg = jsonObject.getString("resultMsg");
        if (resultCode == null || resultMsg == null) {
            return new ApiInvokerException();
        }
        if (!resultCode.equals("0")) {
            return new ApiInvokerException(resultCode, resultMsg);
        }
        return null;
    }

    public Page buildPageByJsonObj(JSONObject jo) {
        if (jo == null) {
            return null;
        }
        Integer pageNo = jo.getInteger("pageNo");
        Integer pageSize = jo.getInteger("pageSize");
        Long count = jo.getLong("count");
        Page p = new Page((int)pageNo, (int)pageSize, count);
        return p;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public HttpRequestUtilBean post(String url, String ... param) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < param.length; i += 2) {
            String key = param[i];
            String value = param.length > i + 1 ? param[i + 1] : null;
            paramMap.put(key, value);
        }
        return this.post(url, paramMap);
    }

    public HttpRequestUtilBean post(String url, Map<String, String> param) {
        HttpRequestUtilBean httpRequestUtilBean;
        String fullUrl = this.baseUrl + url;
        if (param == null) {
            param = new HashMap<String, String>();
        }
        ApiValidateTokenVo apiValidateTokenVo = ApiValidateInterceptor.generateToken(this.primaryKey, param);
        StringBuffer paramBody = new StringBuffer();
        for (String k : param.keySet()) {
            try {
                paramBody.append(String.format("&%s=%s", URLEncoder.encode(k, "utf-8"), param.get(k) == null ? "" : URLEncoder.encode(param.get(k), "utf-8")));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        paramBody.append("&" + apiValidateTokenVo.toString());
        try {
            httpRequestUtilBean = HttpRequestUtil.publicPost(fullUrl, paramBody.substring(1), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ApiInvokerException(e);
        }
        return httpRequestUtilBean;
    }
}

