package com.cxqm.xiaoerke.common.mobile;

import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import com.cxqm.xiaoerke.common.service.MongoDictionaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

public class JMMessageService {

	JMMessageInvoker jmMessageInvoker;

	MongoDictionaryService mongoDictionaryService;

	public JMMessageInvoker getJmMessageInvoker() {
		return jmMessageInvoker;
	}

	public void setJmMessageInvoker(JMMessageInvoker jmMessageInvoker) {
		this.jmMessageInvoker = jmMessageInvoker;
	}

	public MongoDictionaryService getMongoDictionaryService() {
		return mongoDictionaryService;
	}

	public void setMongoDictionaryService(MongoDictionaryService mongoDictionaryService) {
		this.mongoDictionaryService = mongoDictionaryService;
	}

	public void sendMsgFromMongo(String mongoKey, String mobiles) {
		sendMsgFromMongo(mongoKey, mobiles, null);
	}

	public void sendMsgFromMongo(String mongoKey, String mobiles, String[] args) {
		MongoDictionary mongoDictionary = mongoDictionaryService.queryDictionary(mongoKey);
		String content = null;
		if (mongoDictionary != null) {
			content = mongoDictionary.getStr1();
		}
		if (content == null) {
			new IllegalArgumentException("缺少短信内容").printStackTrace();
			return;
		}

		if (args != null && args.length > 0) {
			content = String.format(content, args);
		}

		jmMessageInvoker.sendSMS(mobiles, content);
	}

	public void sendSMS(String mobiles, String content) {
		jmMessageInvoker.sendSMS(mobiles, content);
	}



}
