package com.cxqm.xiaoerke.common.service;

import com.cxqm.xiaoerke.common.bean.MongoDictionary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import java.util.List;

public class MongoDictionaryService {

	@Autowired
	protected MongoTemplate mongoTemplate;

	protected String tableName;

	public MongoTemplate getMongoTemplate() {
		return mongoTemplate;
	}

	public void setMongoTemplate(MongoTemplate mongoTemplate) {
		this.mongoTemplate = mongoTemplate;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}


	public List<MongoDictionary> queryList(String key, String subKey) {
		Criteria criteria = Criteria.where("key").is(key);
		if (subKey != null && subKey.trim().length() != 0) {
			criteria.orOperator(Criteria.where("subKey").is(subKey));
		}
		Query query=new Query(criteria);

		List<MongoDictionary> mongoDictionaries = this.mongoTemplate.find(query, MongoDictionary.class, this.tableName);
		return mongoDictionaries;
	}

	public List<MongoDictionary> queryList(String key) {
		return queryList(key, null);
	}

	public MongoDictionary queryDictionary(String key, String subKey) {
		List<MongoDictionary> mongoDictionaries = queryList(key, subKey);
		if (mongoDictionaries == null || mongoDictionaries.size() == 0) {
			return null;
		}
		return mongoDictionaries.get(0);
	}

	public MongoDictionary queryDictionary(String key) {
		return queryDictionary(key, null);
	}

}

