package com.cxqm.xiaoerke.common.utils;

import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * Created by sunzb on 2017/5/12.
 */
public class PayUtils {

	private static String signPayRequestStr="^%&_";

	private static String signPayCallbackStr="^%&+";

	public static String getPayMapToString(Map<String,String> pay){
		if(pay==null||pay.isEmpty()){
			return null;
		}
		String [] keys = new String[pay.keySet().size()];
		int index = 0;
		for (String key : pay.keySet()){
			keys[index++] = key;
		}
		for (int i = 0; i < keys.length - 1; i++) {
			boolean change = false; // 用作冒泡排序的标记，如果一趟排序存在交换，则change设为true，说明还需要下一趟排序
			for (int j = 0; j < keys.length - i - 1; j++) {
				if (bigger(keys[j], keys[j + 1])) {
					// swap(s[j], s[j + 1]);
					String tmp = keys[j];
					keys[j] = keys[j + 1];
					keys[j + 1] = tmp;
					change = true;
				}
			}
			if (!change) {
				break; // 当change为false的时候，说明不需要再冒泡了
			}
		}
		String res_str = "";
		for(int i=0;i<keys.length;i++){
			res_str+=pay.get(keys[i]);
		}
		return res_str;
	}

	public static String PayRequestSign(Map pay){
		String payMap=getPayMapToString(pay);
		if(payMap==null||payMap.trim().equals("")){
			return null;
		}
		return MD5Util.getMD5String(payMap+signPayRequestStr);
	}

	public static boolean PayRequestValidateSign(String sign,Map pay){
		String payMap=getPayMapToString(pay);
		if(payMap==null||payMap.trim().equals("")){
			return false;
		}
		if(MD5Util.getMD5String(payMap+signPayRequestStr).equalsIgnoreCase(sign)){
			return true;
		}
		return false;
	}

	public static String PayCallbackSign(Map pay){
		String payMap=getPayMapToString(pay);
		if(payMap==null||payMap.trim().equals("")){
			return null;
		}
		return MD5Util.getMD5String(payMap+signPayCallbackStr);
	}

	public static boolean PayCallbackValidateSign(String sign,Map<String,String> pay){
		String payMap=getPayMapToString(pay);
		if(payMap==null||payMap.trim().equals("")){
			return false;
		}
		if(MD5Util.getMD5String(payMap+signPayCallbackStr).equalsIgnoreCase(sign)){
			return true;
		}
		return false;
	}

	/**
	 * 字符串排序返回s1是否大于s2
	 * @param s1
	 * @param s2
	 * @return
	 */
	public static boolean bigger(String s1, String s2) {
		int length1 = s1.length();
		int length2 = s2.length();
		int i = 0;
		while (i < length1 && i < length2) {
			if (s1.charAt(i) > s2.charAt(i)) {
				return true;
			} else if (s1.charAt(i) < s2.charAt(i)) {
				return false;
			} else {
				i++;
			}
		}
		if (i == length1) {
			return false;
		} else {
			return true;
		}
	}
}
