package com.cxqm.xiaoerke.common.utils;

import org.apache.shiro.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

/**
 * Created by sunzsh on 2017/6/28.
 */
public class RedisUtils {
	public static long getIncrValue(final RedisTemplate<String, Object> redisTemplate, final String key) {
		return redisTemplate.execute(new RedisCallback<Long>() {
			@Override
			public Long doInRedis(RedisConnection connection) throws DataAccessException {
				RedisSerializer<String> serializer=redisTemplate.getStringSerializer();
				byte[] rowkey=serializer.serialize(key);
				byte[] rowval=connection.get(rowkey);
				try {
					String val=serializer.deserialize(rowval);
					return Long.parseLong(val);
				} catch (Exception e) {
					return 0L;
				}
			}
		});
	}
}
