package com.cxqm.xiaoerke.common.utils;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.junit.AssertEx;
import com.cxqm.xiaoerke.common.persistence.Page;

import java.util.HashMap;
import java.util.Map;

public class ResponseMapBuilder {

	public static final String KEY_RESULTCODE = "resultCode";
	public static final String KEY_RESULTMSG = "resultMsg";


	public static ResponseMapBuilder emptyBuilder() {
		ResponseMapBuilder builder = new ResponseMapBuilder();
		return builder;
	}

	public static ResponseMapBuilder newBuilder() {
		ResponseMapBuilder builder = new ResponseMapBuilder();
		builder.result = new HashMap<String, Object>();
		return builder;
	}

	public static ResponseMapBuilder newBuilder(Map<String, Object> result) {
		ResponseMapBuilder builder = new ResponseMapBuilder();
		builder.result = result;
		return builder;
	}

	private ResponseMapBuilder() {
	}

	private Map<String, Object> result;

	public Map<String, Object> getResult() {
		return result;
	}

	public void setResult(Map<String, Object> result) {
		this.result = result;
	}

	public ResponseMapBuilder putSuccess() {
		AssertEx.assertNotNull(result);
		put(KEY_RESULTCODE, "0");
		put(KEY_RESULTMSG, "");
		return this;
	}
	public ResponseMapBuilder putBusinessException(BusinessException e) {
		AssertEx.assertNotNull(e);
		put(KEY_RESULTCODE, e.getError().getCode());
		put(KEY_RESULTMSG, e.getError().getDesc());
		return this;
	}

	public ResponseMapBuilder putPageInfo(Page page4api) {
		Map<String, Object> page = ResponseMapBuilder.newBuilder()
				.put("pageNo", page4api.getPageNo())
				.put("pageSize", page4api.getPageSize())
				.put("count", page4api.getCount())
				.put("prev", page4api.getPrev())
				.put("next", page4api.getNext())
				.put("firstPage", page4api.isFirstPage() ? 1 : 0)
				.put("lastPage", page4api.isLastPage() ? 1 : 0)
				.put("data", page4api.getList()).getResult();
		put("result", page);
		return this;
	}

	public ResponseMapBuilder put(String property, Object value) {
		result.put(property, value);
		return this;
	}
}
