/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.web.bind.annotation.RequestBody;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static String getDate() {
        return DateUtils.getDate("yyyy-MM-dd");
    }

    public static String getDate(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern);
    }

    public static String formatDate(Date date, Object ... pattern) {
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        return formatDate;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getTime() {
        return DateUtils.formatDate(new Date(), "HH:mm:ss");
    }

    public static String getDateTime() {
        return DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static double getDistanceMillisecondOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return afterTime - beforeTime;
    }

    public static String getYear() {
        return DateUtils.formatDate(new Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtils.formatDate(new Date(), "MM");
    }

    public static String getDay() {
        return DateUtils.formatDate(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtils.formatDate(new Date(), "E");
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMillisSecond(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t;
    }

    public static long pastMinutes(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 60000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static String timeMillisToDate(long timeMillis) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMillis);
        return formatter.format(calendar.getTime());
    }

    public static double getDistanceOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static double getMinuteOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 60000L;
    }

    public static void main(String[] args) throws ParseException {
    }

    public static String getDayWeek(int week) {
        if (week == 1) {
            return "\u5468\u4e00";
        }
        if (week == 2) {
            return "\u5468\u4e8c";
        }
        if (week == 3) {
            return "\u5468\u4e09";
        }
        if (week == 4) {
            return "\u5468\u56db";
        }
        if (week == 5) {
            return "\u5468\u4e94";
        }
        if (week == 6) {
            return "\u5468\u516d";
        }
        if (week == 7) {
            return "\u5468\u65e5";
        }
        return "";
    }

    public static int dayForWeek(String pTime) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        Calendar c = Calendar.getInstance();
        c.setTime(format.parse(pTime));
        int dayForWeek = 0;
        dayForWeek = c.get(7) == 1 ? 7 : c.get(7) - 1;
        return dayForWeek;
    }

    public static String DateToStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String str = format.format(date);
        return str;
    }

    public static Date formatDate(@RequestBody Map<String, Object> params) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date = null;
        try {
            date = sdf.parse((String)params.get("date"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date formatDateString(String StringDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date = null;
        try {
            date = sdf.parse(StringDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date formatDateToDate(Date date, Object ... pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd hh:mm:ss");
        try {
            date = sdf.parse(formatDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date StrToDate(String str, String flag) {
        SimpleDateFormat format = null;
        format = "time".equals(flag) ? new SimpleDateFormat("HH:mm") : ("date".equals(flag) ? new SimpleDateFormat("yyyy-MM-dd") : ("datetime".equals(flag) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : ("xiangang".equals(flag) ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss") : ("datetimesec".equals(flag) ? new SimpleDateFormat("yyyyMMddHHmmss") : new SimpleDateFormat(flag)))));
        Date date = null;
        try {
            date = format.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date addDate(Date date, long day) throws ParseException {
        long time = date.getTime();
        day = day * 24L * 60L * 60L * 1000L;
        return new Date(time += day);
    }

    public static String DateToStr(Date date, String flag) {
        SimpleDateFormat format = null;
        format = "time".equals(flag) ? new SimpleDateFormat("HH:mm") : ("date".equals(flag) ? new SimpleDateFormat("yyyy-MM-dd") : ("datetime".equals(flag) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : ("monthDate".equals(flag) ? new SimpleDateFormat("MM/dd") : ("monthDate:".equals(flag) ? new SimpleDateFormat("MM:dd") : ("flag1".equals(flag) ? new SimpleDateFormat("MM-dd HH:mm") : new SimpleDateFormat(flag))))));
        String dateStr = null;
        dateStr = format.format(date);
        return dateStr;
    }

    public static String getWeekOfDate(Date dt) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String formatDateToStr(Date date, String formatStr) {
        SimpleDateFormat format = null;
        format = new SimpleDateFormat(formatStr);
        String dateStr = null;
        dateStr = format.format(date);
        return dateStr;
    }

    public static Date getLastDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int d = 0;
        d = cal.get(7) == 1 ? -6 : 2 - cal.get(7);
        cal.add(7, d);
        cal.add(7, 13);
        Date lastTime = cal.getTime();
        return lastTime;
    }

    public static Date getFirstDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int d = 0;
        d = cal.get(7) == 1 ? -6 : 2 - cal.get(7);
        cal.add(7, d);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date firstTime = cal.getTime();
        return firstTime;
    }
}

