/*
 * Decompiled with CFR 0.152.
 */
package com.cxqm.xiaoerke.modules.sys.entity;

import com.cxqm.xiaoerke.common.persistence.DataEntity;
import com.cxqm.xiaoerke.modules.sys.entity.Menu;
import com.cxqm.xiaoerke.modules.sys.entity.Office;
import com.cxqm.xiaoerke.modules.sys.entity.User;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class Role
extends DataEntity<Role> {
    private static final long serialVersionUID = 1L;
    private Office office;
    private String name;
    private String enname;
    private String roleType;
    private String dataScope;
    private String oldName;
    private String oldEnname;
    private String sysData;
    private String useable;
    private User user;
    private List<Menu> menuList = Lists.newArrayList();
    private List<Office> officeList = Lists.newArrayList();
    public static final String DATA_SCOPE_ALL = "1";
    public static final String DATA_SCOPE_COMPANY_AND_CHILD = "2";
    public static final String DATA_SCOPE_COMPANY = "3";
    public static final String DATA_SCOPE_OFFICE_AND_CHILD = "4";
    public static final String DATA_SCOPE_OFFICE = "5";
    public static final String DATA_SCOPE_SELF = "8";
    public static final String DATA_SCOPE_CUSTOM = "9";

    public Role() {
        this.dataScope = DATA_SCOPE_SELF;
        this.useable = DATA_SCOPE_ALL;
    }

    public Role(String id) {
        super(id);
    }

    public Role(User user) {
        this();
        this.user = user;
    }

    public String getUseable() {
        return this.useable;
    }

    public void setUseable(String useable) {
        this.useable = useable;
    }

    public String getSysData() {
        return this.sysData;
    }

    public void setSysData(String sysData) {
        this.sysData = sysData;
    }

    public Office getOffice() {
        return this.office;
    }

    public void setOffice(Office office) {
        this.office = office;
    }

    @Length(min=1, max=100)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Length(min=1, max=100)
    public String getEnname() {
        return this.enname;
    }

    public void setEnname(String enname) {
        this.enname = enname;
    }

    @Length(min=1, max=100)
    public String getRoleType() {
        return this.roleType;
    }

    public void setRoleType(String roleType) {
        this.roleType = roleType;
    }

    public String getDataScope() {
        return this.dataScope;
    }

    public void setDataScope(String dataScope) {
        this.dataScope = dataScope;
    }

    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getOldEnname() {
        return this.oldEnname;
    }

    public void setOldEnname(String oldEnname) {
        this.oldEnname = oldEnname;
    }

    public List<Menu> getMenuList() {
        return this.menuList;
    }

    public void setMenuList(List<Menu> menuList) {
        this.menuList = menuList;
    }

    public List<String> getMenuIdList() {
        ArrayList menuIdList = Lists.newArrayList();
        for (Menu menu : this.menuList) {
            menuIdList.add(menu.getId());
        }
        return menuIdList;
    }

    public void setMenuIdList(List<String> menuIdList) {
        this.menuList = Lists.newArrayList();
        for (String menuId : menuIdList) {
            Menu menu = new Menu();
            menu.setId(menuId);
            this.menuList.add(menu);
        }
    }

    public String getMenuIds() {
        return StringUtils.join(this.getMenuIdList(), (String)",");
    }

    public void setMenuIds(String menuIds) {
        this.menuList = Lists.newArrayList();
        if (menuIds != null) {
            Object[] ids = StringUtils.split((String)menuIds, (String)",");
            this.setMenuIdList(Lists.newArrayList((Object[])ids));
        }
    }

    public List<Office> getOfficeList() {
        return this.officeList;
    }

    public void setOfficeList(List<Office> officeList) {
        this.officeList = officeList;
    }

    public List<String> getOfficeIdList() {
        ArrayList officeIdList = Lists.newArrayList();
        for (Office office : this.officeList) {
            officeIdList.add(office.getId());
        }
        return officeIdList;
    }

    public void setOfficeIdList(List<String> officeIdList) {
        this.officeList = Lists.newArrayList();
        for (String officeId : officeIdList) {
            Office office = new Office();
            office.setId(officeId);
            this.officeList.add(office);
        }
    }

    public String getOfficeIds() {
        return StringUtils.join(this.getOfficeIdList(), (String)",");
    }

    public void setOfficeIds(String officeIds) {
        this.officeList = Lists.newArrayList();
        if (officeIds != null) {
            Object[] ids = StringUtils.split((String)officeIds, (String)",");
            this.setOfficeIdList(Lists.newArrayList((Object[])ids));
        }
    }

    public List<String> getPermissions() {
        ArrayList permissions = Lists.newArrayList();
        for (Menu menu : this.menuList) {
            if (menu.getPermission() == null || "".equals(menu.getPermission())) continue;
            permissions.add(menu.getPermission());
        }
        return permissions;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.office, role.office) && Objects.equals(this.name, role.name) && Objects.equals(this.enname, role.enname) && Objects.equals(this.roleType, role.roleType) && Objects.equals(this.dataScope, role.dataScope) && Objects.equals(this.oldName, role.oldName) && Objects.equals(this.oldEnname, role.oldEnname) && Objects.equals(this.sysData, role.sysData) && Objects.equals(this.useable, role.useable) && Objects.equals(this.user, role.user) && Objects.equals(this.menuList, role.menuList) && Objects.equals(this.officeList, role.officeList);
    }

    public int hashCode() {
        return Objects.hash(this.office, this.name, this.enname, this.roleType, this.dataScope, this.oldName, this.oldEnname, this.sysData, this.useable, this.user, this.menuList, this.officeList);
    }
}

