package com.cxqm.xiaoerke.common.web;

import com.cxqm.xiaoerke.common.bean.BusinessException;
import com.cxqm.xiaoerke.common.utils.ResponseMapBuilder;
import net.sf.json.JSONObject;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

public class JsonpUtils {
	public interface ControllerDelegate {
		Map delegate() throws Exception;
	}

	public static String getResultForJsonp(String callback, ControllerDelegate delegate) {
		Map resultMap = null;
		try {
			resultMap = delegate.delegate();
		} catch (BusinessException e) {
			resultMap = ResponseMapBuilder.newBuilder()
					.putBusinessException(e)
					.getResult();
		} catch (Exception e) {
			e.printStackTrace();
			resultMap = ResponseMapBuilder.newBuilder()
					.put(ResponseMapBuilder.KEY_RESULTCODE, "9999")
					.put(ResponseMapBuilder.KEY_RESULTMSG, e.getMessage()==null?"系统内部异常":e.getMessage())
					.getResult();
		}
		return getByMap(callback, resultMap);
	}

	public static String getResultForJsonp(HttpServletRequest request, ControllerDelegate delegate) {
		String callback = request.getParameter("callback");
		return getResultForJsonp(callback, delegate);
	}

	public static String getByMap(String callback, Map<String,Object> result){
		String strRes = JSONObject.fromObject(result).toString();
		strRes = callback + "(" + strRes + ")";
		return strRes;
	}
}
