/*
 * Decompiled with CFR 0.152.
 */
package com.zthz.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zthz.util.ApiHttpUtil;
import com.zthz.util.ExceptionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HttpReq {
    @Value(value="${modeId}")
    public String modeId;
    @Value(value="${shipApiPath}")
    public String baseUrl;
    @Value(value="${ship_key}")
    public String pk;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public String getBaseUrl() {
        if (this.baseUrl == null || this.baseUrl.trim().length() <= 0) {
            this.logger.error("\u8bf7\u914d\u7f6ewxapi\u8bf7\u6c42\u8def\u5f84\uff01\u914d\u7f6e\u53c2\u6570\u3010wxApiPath=http://xxx.xxx.xxx\u3011\u5230\u914d\u7f6e\u6587\u4ef6");
        }
        return this.baseUrl;
    }

    public String getPk() {
        return this.pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void req(String path, Map<String, Object> paramMap) {
        this.req(path, paramMap, null);
    }

    private JSON reqJSONData(String path, Map<String, Object> paramMap) {
        String result;
        if (paramMap == null) {
            paramMap = new HashMap<String, Object>();
        }
        if ((result = ApiHttpUtil.post(this.getBaseUrl() + path, this.pk, paramMap, this.modeId)) == null || "".equals(result)) {
            return null;
        }
        JSONObject obj = null;
        try {
            obj = JSON.parseObject((String)result);
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u8fd4\u56de\u4fe1\u606f\u65e0\u6cd5\u89e3\u6790\u4e3aJSON\u683c\u5f0f\uff01\u5f02\u5e38\u4fe1\u606f:" + ExceptionInfo.toStr(e));
            return null;
        }
        if (!"0".equals(obj.getString("resultCode"))) {
            this.logger.error("\u63a5\u53e3\u5f02\u5e38\uff1a" + obj.getString("resultMsg"));
            return null;
        }
        return (JSON)JSON.parse((String)obj.getString("data"));
    }

    public <T> T req(String path, Map<String, Object> paramMap, Class<T> clazz) {
        JSON json = this.reqJSONData(path, paramMap);
        if (json == null) {
            return null;
        }
        return (T)json.toJavaObject(clazz);
    }

    public <T> List<T> reqList(String path, Map<String, Object> paramMap, Class<T> clazz) {
        JSON json = this.reqJSONData(path, paramMap);
        if (json instanceof JSONArray) {
            return ((JSONArray)json).toJavaList(clazz);
        }
        if (json instanceof JSONObject) {
            Object t = json.toJavaObject(clazz);
            ArrayList<Object> ts = new ArrayList<Object>();
            ts.add(t);
            return ts;
        }
        if (json == null) {
            return null;
        }
        throw new IllegalArgumentException("\u8fd4\u56de\u7c7b\u578b\u5f02\u5e38");
    }
}

