/*
 * Decompiled with CFR 0.152.
 */
package com.zthz.bean;

import cn.hutool.core.util.NumberUtil;
import com.zthz.bean.ShipBasic;
import com.zthz.bean.ShipDocument;
import com.zthz.bean.ShipTrack;
import java.util.Date;
import java.util.Optional;

public class AisData {
    private String shipId;
    private String mmsi;
    private String shipNameEN;
    private String shipNameCN;
    private String callSign;
    private Integer imo;
    private String shipType;
    private String shipTypeName;
    private String eta;
    private String etaStd;
    private String dest;
    private String destStd;
    private String destCode;
    private String course;
    private String heading;
    private String navStatus;
    private String navStatusName;
    private Double draught;
    private Double speed;
    private Double length;
    private Double width;
    private Long postime;
    private Long longitude;
    private Long latitude;

    public String getShipId() {
        return this.shipId;
    }

    public void setShipId(String shipId) {
        this.shipId = shipId;
    }

    public String getMmsi() {
        return this.mmsi;
    }

    public void setMmsi(String mmsi) {
        this.mmsi = mmsi;
    }

    public String getShipNameEN() {
        return this.shipNameEN;
    }

    public void setShipNameEN(String shipNameEN) {
        this.shipNameEN = shipNameEN;
    }

    public String getShipNameCN() {
        return this.shipNameCN;
    }

    public void setShipNameCN(String shipNameCN) {
        this.shipNameCN = shipNameCN;
    }

    public String getCallSign() {
        return this.callSign;
    }

    public void setCallSign(String callSign) {
        this.callSign = callSign;
    }

    public Integer getImo() {
        return this.imo;
    }

    public void setImo(Integer imo) {
        this.imo = imo;
    }

    public String getShipType() {
        return this.shipType;
    }

    public void setShipType(String shipType) {
        this.shipType = shipType;
    }

    public String getShipTypeName() {
        return this.shipTypeName;
    }

    public void setShipTypeName(String shipTypeName) {
        this.shipTypeName = shipTypeName;
    }

    public String getEta() {
        return this.eta;
    }

    public void setEta(String eta) {
        this.eta = eta;
    }

    public String getEtaStd() {
        return this.etaStd;
    }

    public void setEtaStd(String etaStd) {
        this.etaStd = etaStd;
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public String getDestStd() {
        return this.destStd;
    }

    public void setDestStd(String destStd) {
        this.destStd = destStd;
    }

    public String getDestCode() {
        return this.destCode;
    }

    public void setDestCode(String destCode) {
        this.destCode = destCode;
    }

    public String getCourse() {
        return this.course;
    }

    public void setCourse(String course) {
        this.course = course;
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public String getNavStatus() {
        return this.navStatus;
    }

    public void setNavStatus(String navStatus) {
        this.navStatus = navStatus;
    }

    public String getNavStatusName() {
        return this.navStatusName;
    }

    public void setNavStatusName(String navStatusName) {
        this.navStatusName = navStatusName;
    }

    public Double getDraught() {
        return this.draught;
    }

    public void setDraught(Double draught) {
        this.draught = draught;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Double getLength() {
        return this.length;
    }

    public void setLength(Double length) {
        this.length = length;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Long getPostime() {
        return this.postime;
    }

    public void setPostime(Long postime) {
        this.postime = postime;
    }

    public Long getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Long longitude) {
        this.longitude = longitude;
    }

    public Long getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Long latitude) {
        this.latitude = latitude;
    }

    private Double lgltConvert(Double value) {
        if (value == null) {
            return null;
        }
        double res = value / 1000000.0;
        return NumberUtil.round((double)res, (int)6).doubleValue();
    }

    public Double getLog() {
        return this.lgltConvert(new Double(this.getLongitude().longValue()));
    }

    public Double getLat() {
        return this.lgltConvert(new Double(this.getLatitude().longValue()));
    }

    public ShipTrack toShipTrack(String id, Date createTime) {
        ShipTrack shipTrack = new ShipTrack();
        shipTrack.setId(id);
        shipTrack.setShipId(this.getShipId());
        shipTrack.setMmsi(this.getMmsi());
        shipTrack.setLongitude(this.numStr(this.getLog()));
        shipTrack.setLatitude(this.numStr(this.getLat()));
        shipTrack.setCourse(this.getCourse());
        shipTrack.setSpeed(this.numStr(this.getSpeed()));
        shipTrack.setPostime(this.numStr(this.getPostime()));
        shipTrack.setCreateTime(createTime);
        shipTrack.setEtatime(this.getEtaStd());
        shipTrack.setDestPort(this.getDest());
        shipTrack.setCourse(this.getCourse());
        shipTrack.setHeading(this.getHeading());
        shipTrack.setNavStatus(this.getNavStatus());
        shipTrack.setDraught(this.getDraught() == null ? null : Float.valueOf(this.getDraught().floatValue()));
        return shipTrack;
    }

    public ShipDocument toShipDocument() {
        ShipDocument mdShipPositn = new ShipDocument();
        mdShipPositn.setId(this.getShipId());
        mdShipPositn.setEta(this.getEta());
        mdShipPositn.setShipMmsi(this.getMmsi());
        mdShipPositn.setEtatime(this.getEtaStd());
        mdShipPositn.setShipName(this.getShipNameEN());
        mdShipPositn.setPostime(this.numStr(this.getPostime()));
        mdShipPositn.setPosition(new double[]{this.getLog(), this.getLat()});
        mdShipPositn.setNavStatus(this.getNavStatus());
        mdShipPositn.setNavStatusName(this.getNavStatusName());
        mdShipPositn.setShipTypeName(this.getShipTypeName());
        mdShipPositn.setShipType(this.getShipType());
        mdShipPositn.setHeading(this.getHeading());
        mdShipPositn.setDestPort(this.getDest());
        mdShipPositn.setDraught(Optional.ofNullable(this.getDraught()).map(d -> Float.valueOf(d.floatValue())).orElse(null));
        mdShipPositn.setCourse(this.getCourse());
        mdShipPositn.setSpeed(this.numStr(this.getSpeed()));
        mdShipPositn.setMmsi(this.getMmsi());
        mdShipPositn.setLength(this.numStr(this.getLength()));
        mdShipPositn.setBreadth(this.numStr(this.getWidth()));
        mdShipPositn.setLatitude(this.getLatitude().intValue() * 6);
        mdShipPositn.setLongitude(this.getLongitude().intValue() * 6);
        return mdShipPositn;
    }

    public ShipBasic toShipBasic() {
        ShipBasic shipBasic = new ShipBasic();
        shipBasic.setId(this.getShipId());
        shipBasic.setShipName(this.getShipNameEN());
        shipBasic.setShipMmsi(this.getMmsi());
        shipBasic.setCallsign(this.getCallSign());
        shipBasic.setCreateTime(new Date());
        shipBasic.setSptime(Optional.ofNullable(this.getPostime()).map(Long::intValue).orElse(null));
        shipBasic.setDraught(Optional.ofNullable(this.getDraught()).map(Double::floatValue).orElse(null));
        shipBasic.setEtatime(this.getEtaStd());
        shipBasic.setImo(Optional.ofNullable(this.getImo()).map(t -> t.toString()).orElse(null));
        shipBasic.setShipType(Optional.ofNullable(this.getShipType()).map(Integer::parseInt).orElse(null));
        shipBasic.setShipLength(Optional.ofNullable(this.getLength()).map(Double::floatValue).orElse(null));
        shipBasic.setShipWeight(Optional.ofNullable(this.getWidth()).map(Double::floatValue).orElse(null));
        shipBasic.setDelTime(0);
        return shipBasic;
    }

    private String numStr(Number num) {
        if (num == null) {
            return "";
        }
        return num + "";
    }
}

