/*
 * Decompiled with CFR 0.152.
 */
package com.zthz.api;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.zthz.api.HttpReq;
import com.zthz.bean.ShipDtTrackDto;
import com.zthz.bean.ShipTrackDto;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShipTrackServiceApi {
    @Autowired
    public HttpReq httpReq;

    public HttpReq getHttpReq() {
        return this.httpReq;
    }

    public void setHttpReq(HttpReq httpReq) {
        this.httpReq = httpReq;
    }

    public JSONArray queryHistoryByMmsi(String mmsi, String startTime, String endTime) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi == null ? "" : mmsi);
        paramMap.put("startTime", startTime == null ? "" : startTime);
        paramMap.put("endTime", endTime == null ? "" : endTime);
        JSONArray result = this.httpReq.req("/ship/ship-track/queryHistoryByMmsi", paramMap, JSONArray.class);
        return result;
    }

    public JSONArray selectHistoryByUnitTime(String mmsi, Integer maxCount, Long intervalSecond, String startTime, String endTime) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi == null ? "" : mmsi);
        paramMap.put("maxCount", maxCount == null ? "" : maxCount);
        paramMap.put("intervalSecond", intervalSecond == null ? "" : intervalSecond);
        paramMap.put("startTime", startTime == null ? "" : startTime);
        paramMap.put("endTime", endTime == null ? "" : endTime);
        JSONArray result = this.httpReq.req("/ship/ship-track/selectHistoryByUnitTime", paramMap, JSONArray.class);
        return result;
    }

    public JSONArray queryShipTrackByMMSI(String mmsis) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsis == null ? "" : mmsis);
        JSONArray result = this.httpReq.req("/ship/ship-track/queryShipTrackByMMSI", paramMap, JSONArray.class);
        return result;
    }

    public JSONArray queryVagueShipTrackByMMSI(String mmsis) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsis", mmsis == null ? "" : mmsis);
        JSONArray result = this.httpReq.req("/ship/ship-track/queryVagueShipTrackByMMSI", paramMap, JSONArray.class);
        return result;
    }

    public List selectShipStatusByPage(String mmsis, Integer pageSize, Integer pageNum) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsis == null ? "" : mmsis);
        paramMap.put("pageSize", pageSize);
        paramMap.put("pageNum", pageNum);
        List result = this.httpReq.req("/ship/ship-track/selectShipStatusByPage", paramMap, List.class);
        return result;
    }

    public List<ShipTrackDto> selectShipTrackHistory(String mmsi, Integer startUnixTime, Integer endUnixTime) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi);
        paramMap.put("startTime", startUnixTime);
        paramMap.put("endTime", endUnixTime);
        return this.httpReq.req("/ship/ship-track/selectShipTrackHistory", paramMap, List.class);
    }

    public ShipDtTrackDto getShipDtTrack(String mmsi) {
        if (StrUtil.isBlank((CharSequence)mmsi)) {
            return null;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi);
        return this.httpReq.req("/ship/ship-track/getShipDtTrack", paramMap, ShipDtTrackDto.class);
    }
}

