/*
 * Decompiled with CFR 0.152.
 */
package com.zthz.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zthz.util.ApiHttpUtil;
import com.zthz.util.ExceptionInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HttpReq {
    @Value(value="${modeId}")
    public String modeId;
    @Value(value="${shipApiPath}")
    public String baseUrl;
    @Value(value="${ship_key}")
    public String pk;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public String getBaseUrl() {
        if (this.baseUrl == null || this.baseUrl.trim().length() <= 0) {
            this.logger.error("\u8bf7\u914d\u7f6ewxapi\u8bf7\u6c42\u8def\u5f84\uff01\u914d\u7f6e\u53c2\u6570\u3010wxApiPath=http://xxx.xxx.xxx\u3011\u5230\u914d\u7f6e\u6587\u4ef6");
        }
        return this.baseUrl;
    }

    public String getPk() {
        return this.pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void req(String path, Map<String, Object> paramMap) {
        this.req(path, paramMap, null);
    }

    private Object reqJSONData(String path, Map<String, Object> paramMap) {
        String result;
        if (paramMap == null) {
            paramMap = new HashMap<String, Object>();
        }
        if ((result = ApiHttpUtil.post(this.getBaseUrl() + path, this.pk, paramMap, this.modeId)) == null || "".equals(result)) {
            return null;
        }
        Object obj = null;
        try {
            obj = JSON.parse((String)result);
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u8fd4\u56de\u4fe1\u606f\u65e0\u6cd5\u89e3\u6790\u4e3aJSON\u683c\u5f0f\uff01\u5f02\u5e38\u4fe1\u606f:" + ExceptionInfo.toStr(e));
            return null;
        }
        if (obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)obj;
            if (!"0".equals(jsonObject.getString("resultCode"))) {
                this.logger.error("\u63a5\u53e3\u5f02\u5e38\uff1a" + jsonObject.getString("resultMsg"));
                return null;
            }
            return JSON.parse((String)jsonObject.getString("data"));
        }
        return obj;
    }

    public <T> T req(String path, Map<String, Object> paramMap, Class<T> clazz) {
        Object object = this.reqJSONData(path, paramMap);
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            return (T)((JSONObject)object).toJavaObject(clazz);
        }
        if (object instanceof JSONArray) {
            return (T)((JSONArray)object).toJavaObject(clazz);
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (Number.class.isAssignableFrom(clazz) && Number.class.isAssignableFrom(object.getClass())) {
            Number num = (Number)object;
            if (clazz.isAssignableFrom(Long.class)) {
                return clazz.cast(num.longValue());
            }
            if (clazz.isAssignableFrom(Integer.class)) {
                return clazz.cast(num.intValue());
            }
            if (clazz.isAssignableFrom(Double.class)) {
                return clazz.cast(num.doubleValue());
            }
            if (clazz.isAssignableFrom(Float.class)) {
                return clazz.cast(Float.valueOf(num.floatValue()));
            }
            if (clazz.isAssignableFrom(Short.class)) {
                return clazz.cast(num.shortValue());
            }
            if (clazz.isAssignableFrom(BigInteger.class)) {
                return clazz.cast(BigInteger.valueOf(num.longValue()));
            }
            if (clazz.isAssignableFrom(BigDecimal.class)) {
                return clazz.cast(new BigDecimal(num.doubleValue()));
            }
        } else if (Objects.equals(String.class, clazz)) {
            return (T)Objects.toString(object);
        }
        throw new IllegalArgumentException("unknow type for returns.");
    }

    public <T> List<T> reqList(String path, Map<String, Object> paramMap, Class<T> clazz) {
        Object object = this.reqJSONData(path, paramMap);
        if (object instanceof JSONArray) {
            return ((JSONArray)object).toJavaList(clazz);
        }
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            Object t = jsonObject.toJavaObject(clazz);
            ArrayList<Object> ts = new ArrayList<Object>();
            ts.add(t);
            return ts;
        }
        if (object == null) {
            return null;
        }
        throw new IllegalArgumentException("\u8fd4\u56de\u7c7b\u578b\u5f02\u5e38");
    }

    public <T> Page<T> reqPage(String path, Map<String, Object> paramMap, Class<T> clazz) {
        Object object = this.reqJSONData(path, paramMap);
        if (!(object instanceof JSONObject)) {
            throw new IllegalArgumentException("\u8fd4\u56de\u7c7b\u578b\u5f02\u5e38");
        }
        JSONObject res = (JSONObject)object;
        List records = res.getJSONArray("records").toJavaList(clazz);
        Integer total = res.getInteger("total");
        Integer size = res.getInteger("size");
        Integer current = res.getInteger("current");
        Integer pages = res.getInteger("pages");
        Page objectPage = new Page();
        objectPage.setRecords(records);
        objectPage.setTotal((long)total.intValue());
        objectPage.setSize((long)size.intValue());
        objectPage.setCurrent((long)current.intValue());
        objectPage.setPages((long)pages.intValue());
        return objectPage;
    }
}

