/*
 * Decompiled with CFR 0.152.
 */
package com.zthz.api;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zthz.api.HttpReq;
import com.zthz.bean.PortTurnoverDeatil;
import com.zthz.bean.ShipLine;
import com.zthz.bean.ShipLineBean;
import com.zthz.bean.ShipLineGoodsbelong;
import com.zthz.bean.SimpleShipGoodsBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShipLineApi {
    @Autowired
    public HttpReq httpReq;

    public HttpReq getHttpReq() {
        return this.httpReq;
    }

    public void setHttpReq(HttpReq httpReq) {
        this.httpReq = httpReq;
    }

    public List<ShipLine> selectShipLineByMmsi(String mmsi) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi == null ? "" : mmsi);
        List result = this.httpReq.req("/voyagetest/shipline/selectShipLineByMmsi", paramMap, List.class);
        return result;
    }

    public List<PortTurnoverDeatil> selectPortTurnoverInfo(String portId, Integer startindex, Integer size) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("portId", portId == null ? "" : portId);
        paramMap.put("startindex", startindex == null ? "" : startindex);
        paramMap.put("size", size == null ? "" : size);
        List<PortTurnoverDeatil> result = this.httpReq.reqList("/voyagetest/shipline/selectPortTurnoverInfo", paramMap, PortTurnoverDeatil.class);
        return result;
    }

    public List<PortTurnoverDeatil> selectNearOneMonthInfo(String mmsi, Integer startindex, Integer size) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi == null ? "" : mmsi);
        paramMap.put("startindex", startindex == null ? "" : startindex);
        paramMap.put("size", size == null ? "" : size);
        List<PortTurnoverDeatil> result = this.httpReq.reqList("/voyagetest/shipline/selectNearOneMonthInfo", paramMap, PortTurnoverDeatil.class);
        return result;
    }

    public ShipLineBean selectLastInfoBymmsi(String mmsi) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi == null ? "" : mmsi);
        ShipLineBean result = this.httpReq.req("/voyagetest/shipline/selectLastInfoBymmsi", paramMap, ShipLineBean.class);
        return result;
    }

    public List<ShipLineGoodsbelong> selectGoodsByShipLineId(String shipLineId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("shipLineId", shipLineId == null ? "" : shipLineId);
        List<ShipLineGoodsbelong> result = this.httpReq.reqList("/voyagetest/shiplinegoodsbelong/selectHuoWu", paramMap, ShipLineGoodsbelong.class);
        return result;
    }

    public List<ShipLine> selectGoodsByShipName(String shipName) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("shipName", shipName == null ? "" : shipName);
        List<ShipLine> result = this.httpReq.reqList("/pdc-ship/selectGoodsByShipName", paramMap, ShipLine.class);
        return result;
    }

    public Map<String, Object> getShipLineInfo(String mmsi) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi == null ? "" : mmsi);
        return this.httpReq.req("/voyagetest/shipline/getShipLineInfo", paramMap, Map.class);
    }

    public List<SimpleShipGoodsBean> selectGoodsByShipNameList(List<String> shipNames) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("shipNames", shipNames == null ? "" : shipNames);
        List<SimpleShipGoodsBean> result = this.httpReq.reqList("/pdc-ship/selectGoodsByShipNameList", paramMap, SimpleShipGoodsBean.class);
        return result;
    }

    public Page<ShipLine> getRecentShiplines(String mmsi, Long minMeterOfDistance, Integer page, Integer size, Boolean endportAllowNull) {
        Assert.notNull((Object)mmsi, (String)"mmsi\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi);
        paramMap.put("minMeterOfDistance", minMeterOfDistance);
        paramMap.put("pageNum", page == null ? "1" : page);
        paramMap.put("size", size == null ? "10" : size);
        paramMap.put("endportAllowNull", endportAllowNull == null || endportAllowNull == false ? 0 : 1);
        Page<ShipLine> result = this.httpReq.reqPage("/voyagetest/shipline/getRecentShiplines", paramMap, ShipLine.class);
        return result;
    }

    public Page<ShipLine> getRecentShiplines(String mmsi, Long minMeterOfDistance, Integer page, Integer size) {
        return this.getRecentShiplines(mmsi, minMeterOfDistance, page, size, false);
    }

    public ShipLine findPrevious(String mmsi, String startPortAnchorTime, String startPortBerthTime) {
        Assert.notNull((Object)mmsi, (String)"mmsi\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)startPortAnchorTime, (String)"startPortAnchorTime\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi);
        paramMap.put("startPortAnchorTime", startPortAnchorTime);
        paramMap.put("startPortBerthTime", startPortBerthTime);
        ShipLine result = this.httpReq.req("/voyagetest/shipline/findPrevious", paramMap, ShipLine.class);
        return result;
    }
}

