/*
 * Decompiled with CFR 0.152.
 */
package com.zthz.api;

import com.alibaba.fastjson.JSONArray;
import com.zthz.api.HttpReq;
import com.zthz.bean.AisData;
import com.zthz.bean.ShipBasic;
import com.zthz.bean.ShipBasicNewsBean;
import com.zthz.bean.ShipDocument;
import com.zthz.bean.ShipInfoBean;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShipBaseApi {
    @Autowired
    public HttpReq httpReq;

    public HttpReq getHttpReq() {
        return this.httpReq;
    }

    public void setHttpReq(HttpReq httpReq) {
        this.httpReq = httpReq;
    }

    public ShipDocument getById(String id) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id == null ? "" : id);
        ShipDocument result = this.httpReq.req("/ship/ship-basic/getById", paramMap, ShipDocument.class);
        return result;
    }

    public ShipDocument getByMmsi(String mmsi) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi == null ? "" : mmsi);
        ShipDocument result = this.httpReq.req("/ship/ship-basic/getByMmsi", paramMap, ShipDocument.class);
        return result;
    }

    public List<ShipBasicNewsBean> getShipBasicNews(String pageNo, String pageSize) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pageNo", pageNo == null ? "" : pageNo);
        paramMap.put("pageSize", pageSize == null ? "" : pageSize);
        List result = this.httpReq.req("/ship/ship-basic/getShipBasicNews", paramMap, List.class);
        return result;
    }

    public JSONArray getShipInfo(String mmsis) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsis", mmsis == null ? "" : mmsis);
        JSONArray result = this.httpReq.req("/ship/ship-basic/getShipInfo", paramMap, JSONArray.class);
        return result;
    }

    public List<AisData> querySCShipListByParam(String shipname) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("shipname", shipname == null ? "" : shipname);
        List result = this.httpReq.req("/ship/ship-basic/querySCShipListByParam", paramMap, List.class);
        return result;
    }

    public AisData querySCShipByMssi(String mmsi) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mmsi", mmsi == null ? "" : mmsi);
        AisData result = this.httpReq.req("/ship/ship-basic/querySCShipByMssi", paramMap, AisData.class);
        return result;
    }

    public List<ShipBasic> selectShipsByQuery(String strat, String end, String tonnage) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("strat", strat == null ? "" : strat);
        paramMap.put("end", end == null ? "" : end);
        paramMap.put("tonnage", tonnage == null ? "" : tonnage);
        List result = this.httpReq.req("/ship/ship-basic/selectShipsByQuery", paramMap, List.class);
        return result;
    }

    public List<ShipBasic> queryByGroupingAndOherCriteria(String groupname, Integer maxDeadWeight, Integer minDeadWeight, String emptyOverloadState, String zPortId, String xPortId, String etatime, String shipName, String shipMmsi) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("groupname", groupname == null ? "" : groupname);
        paramMap.put("maxDeadWeight", maxDeadWeight == null ? "" : maxDeadWeight);
        paramMap.put("minDeadWeight", minDeadWeight == null ? "" : minDeadWeight);
        paramMap.put("emptyOverloadState", emptyOverloadState == null ? "" : emptyOverloadState);
        paramMap.put("zPortId", zPortId == null ? "" : zPortId);
        paramMap.put("xPortId", zPortId == null ? "" : xPortId);
        paramMap.put("etatime", etatime == null ? "" : etatime);
        paramMap.put("shipName", shipName == null ? "" : shipName);
        paramMap.put("shipMmsi", etatime == null ? "" : shipMmsi);
        List result = this.httpReq.req("/ship/ship-basic/queryByGroupingAndOherCriteria", paramMap, List.class);
        return result;
    }

    public List<ShipInfoBean> queryByGroupingAndOtherCriteria(String groupname, Integer maxDeadWeight, Integer minDeadWeight, String emptyOverloadState, String zPortId, String xPortId, String etatime, String shipName, String shipMmsi, Integer startIndex, Integer size) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("groupname", groupname == null ? "" : groupname);
        paramMap.put("maxDeadWeight", maxDeadWeight == null ? "" : maxDeadWeight);
        paramMap.put("minDeadWeight", minDeadWeight == null ? "" : minDeadWeight);
        paramMap.put("emptyOverloadState", emptyOverloadState == null ? "" : emptyOverloadState);
        paramMap.put("zPortId", zPortId == null ? "" : zPortId);
        paramMap.put("xPortId", zPortId == null ? "" : xPortId);
        paramMap.put("etatime", etatime == null ? "" : etatime);
        paramMap.put("shipName", shipName == null ? "" : shipName);
        paramMap.put("shipMmsi", etatime == null ? "" : shipMmsi);
        paramMap.put("startIndex", startIndex == null ? "" : startIndex);
        paramMap.put("size", size == null ? "" : size);
        List result = this.httpReq.req("/ship/ship-basic/queryByGroupingAndOtherCriteria", paramMap, List.class);
        return result;
    }
}

