package com.zthzinfo.shipservice.base;

import lombok.Data;
import lombok.ToString;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexType;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.util.List;

/*
{
    "_id" : "4696884776177954046",
    "RecordTime" : "2019-09-02 02:05:27",
    "State" : 1,
    "Code" : "T002",
    "Name" : "丹东新港",
    "ENName" : "DANDONGXINGANG",
    "PYName" : "DDXG",
    "CoordX" : 124.15667,
    "CoordY" : 39.81667,
    "DataType" : 1,
    "AreaID" : "5432072060831556751",
    "position" : [
        124.15667,
        39.81667
    ],
    "Benchmark": "在平均海面下354cm",
    "tide_infos": [
        {
            "date": "2022-12-22",
            "tideHourly": [182, 142, 108 ...],
            "tideTable": [ { "time": "05:38", "height": 32, "type":"L"}, ... ],
            "updateTime": 1671697883
        }
    ]
}
*/
@Data
@ToString
@Document(collection="tide_poi")
public class TidePoiDocument {
    @Id
    private String id;
    @Field("RecordTime")
    private String recordTime;
    @Field("State")
    private Integer state;
    @Field("Code")
    private String code;
    @Field("Name")
    private String name;
    @Field("ENName")
    private String enName;
    @Field("PYName")
    private String pyName;
    @Field("CoordX")
    private Double coordX;
    @Field("CoordY")
    private Double coordY;
    @Field("DataType")
    private Integer dataType;
    @Field("AreaID")
    private String areaId;
    @GeoSpatialIndexed(type = GeoSpatialIndexType.GEO_2DSPHERE)
    private double[] position;//位置信息
    @Field("Benchmark")
    private String benchmark;
    @Field("tide_infos")
    @DBRef
    private List<TideInfo> tideInfos;


}
