package com.zthzinfo.shipservice.bean;

import cn.hutool.core.util.IdUtil;
import lombok.Data;

import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

@Data
public class DelayBean implements Delayed {

    private  String id;  //唯一标识
    private  long delay; //延迟时间
    private  long expire;  //到期时间
    private  Object data;   //数据
    private DelayQueueEvent event;

    public DelayBean(String id) {
        this.id = id;
    }


    public DelayBean(long delay, Object data) {
       this(null , delay , data, null );
    }
    public DelayBean(String id ,long delay , Object data ,DelayQueueEvent event){
        this.delay = delay;
        if(id == null){
            id = IdUtil.simpleUUID();
        }
        this.id = id;
        expire = System.currentTimeMillis() + delay;    //到期时间 = 当前时间+延迟时间
        this.data = data;
        this.event = event;
    }


    /**
     * 需要实现的接口，获得延迟时间   用过期时间-当前时间
     *
     * @param unit
     * @return
     */
    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    /**
     * 用于延迟队列内部比较排序   当前时间的延迟时间 - 比较对象的延迟时间
     *
     * @param o
     * @return
     */
    @Override
    public int compareTo(Delayed o) {
        return (int) (this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
    }


    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj  == null)
            return false;
        if (!(obj instanceof DelayQueueEvent)) {
            return false;
        }
        return Objects.equals(this.getId(), ((DelayBean)obj).getId());
    }
}

