package com.zthzinfo.shipservice.bean;

import com.zthzinfo.shipservice.entity.ShipSnapshot;
import com.zthzinfo.shipservice.enums.EmptyOverloadStateEnum;
import com.zthzinfo.shipservice.enums.ShipStatusEnum;
import lombok.Data;

import java.util.Date;

@Data
public class ShipSnapshotBean extends ShipSnapshot {


    Double finallyDis;
    Double current2destdistance;
    Double dest2choosedistance;
    Integer deadWeight;
    String portName;
    Integer numberOfHatch;
	String name2;

    String imo;

    Integer left;

    Integer trail;


    public Double getFinallyDis() {
        return finallyDis;
    }

    public void setFinallyDis(Double finallyDis) {
        this.finallyDis = finallyDis;
    }

    public String getPortName() {
        return portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public Integer getDeadWeight() {
        if(deadWeight==null){
          return 0;
        }
        return deadWeight;
    }

    public void setDeadWeight(Integer deadWeight) {
        this.deadWeight = deadWeight;
    }

    public Double getCurrent2destdistance() {
        if(current2destdistance==null){
            return 0d;
        }
        return current2destdistance;
    }

    public void setCurrent2destdistance(Double current2destdistance) {
        this.current2destdistance = current2destdistance;
    }

    public Double getDest2choosedistance() {
        if(dest2choosedistance==null){
            dest2choosedistance = 0d;
        }
        return dest2choosedistance;
    }

    public void setDest2choosedistance(Double dest2choosedistance) {
        this.dest2choosedistance = dest2choosedistance;
    }

    public ShipSnapshotBean() {
    }
    public ShipSnapshotBean(ShipSnapshot shipSnapshot) {
        this.setId(shipSnapshot.getId());
        this.setShipId(shipSnapshot.getShipId());
        this.setLongitude(shipSnapshot.getLongitude());
        this.setLatitude(shipSnapshot.getLatitude());
        this.setDrainage(shipSnapshot.getDrainage());
        this.setStatus(shipSnapshot.getStatus());
        this.setNearbyPort(shipSnapshot.getNearbyPort());
        this.setPortOfArrival(shipSnapshot.getPortOfArrival());
        this.setSpeed(shipSnapshot.getSpeed());
        this.setLastUpdateTime(shipSnapshot.getLastUpdateTime());
        this.setCreateTime(shipSnapshot.getCreateTime());
        this.setCreateBy(shipSnapshot.getCreateBy());
        this.setUpdateTime(shipSnapshot.getUpdateTime());
        this.setUpdateBy(shipSnapshot.getUpdateBy());
        this.setIsDel(shipSnapshot.getIsDel());
        this.setMmsi(shipSnapshot.getMmsi());
        this.setDestPort(shipSnapshot.getDestPort());
        this.setDestPortId(shipSnapshot.getDestPortId());
        this.setEtatime(shipSnapshot.getEtatime());
        this.setStatus2(shipSnapshot.getStatus2());
        this.setStatus2Time(shipSnapshot.getStatus2Time());
        this.setGroundId(shipSnapshot.getGroundId());
        this.setEmptyOverloadState(shipSnapshot.getEmptyOverloadState());
        this.setEmptyOverloadStateUpdateTime(shipSnapshot.getEmptyOverloadStateUpdateTime());
        this.setCourse(shipSnapshot.getCourse());
        this.setHeading(shipSnapshot.getHeading());
    }
    private String status2Name;
    private String destPortName;
    private String shipName;
    private String shipTypeName;
    private String callsign;
    private Float shipLength;
    private Float shipWidth;
    private Integer shipWeight;
    private String emptyOverloadStateName;
    private String nearbyPortName;
    private String portArrivalName;
    private String diffTime;
    private String shipCompanyName;
    private String chuanDai;
    private String shiptype;
}
