package com.zthzinfo.shipservice.constants;

/**
 * @Desc : 系统常量
 * @Create : zhaoey ~ 2020/04/07
 */
public class BaseConstants {

    /**
     * 创建者
     */
    public static final String AUTHOR_SYS_LISTENER = "[SYS_LISTENER]";
    public static final String AUTHOR_SYS_CRON = "[SYS_CRON]";
    public static final String AUTHOR_PDC_SHIP = "[PDC_SHIP]";
    public static final String AUTHOR_SHIP_SNAPSHOT = "[SHIP_SNAPSHOT]";
    public static final String AUTHOR_CLOUD_SHIP_ADMIN = "[SHIP_ADMIN]";

    /**
     * 船舶动态
     */
    public static final Integer YU_DI = 0;   //预抵:在锚船动态：有预抵时间
    public static final Integer MAOBO_DENGBO = 1;  //锚泊-等泊：在锚船动态：有下锚时间
    public static final Integer DAIKAO =2;  //待靠：靠泊计划，有预计靠泊时间
    public static final Integer TO_KAOBO = 3;  //前往靠泊：云船在航（云船如果有这条船）；靠泊计划：有预计靠泊时间且晚于当前时间
    public static final Integer KAOBO = 4;  //已靠泊：在港船动态or进出港：有靠泊时间且没有开始作业时间
    public static final Integer KAOBO_WORKING = 5;  //靠泊-作业中：在港船动态or进出港：有开始作业时间且没有结束作业时间
    public static final Integer KAOBO_WANT_LOBO = 6;  //靠泊-待离泊
    public static final Integer LOBO = 7;  //已离泊：进出港：有准确离泊时间（非预计）

    /**
     * 数据抓取的港口
     */
    public static final String PDCSHIP_DATASOURCE_BLDC = "北仑电厂";
    public static final String PDCSHIP_DATASOURCE_TSG = "唐山港";
    public static final String PDCSHIP_DATASOURCE_GZG = "广州港";
    public static final String PDCSHIP_DATASOURCE_CFD = "曹妃甸";
    public static final String PDCSHIP_DATASOURCE_QHD = "秦皇岛";
    public static final String PDCSHIP_DATASOURCE_YKG = "营口港";
    public static final String PDCSHIP_DATASOURCE_LYG = "连云港";
    public static final String PDCSHIP_DATASOURCE_HHG = "黄骅港";

    /**
     * controller返回数据的字段
     */
    public static final String RESPONSE_DATA = "data";

    public static final String DF_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String DF_DD_HH = "dd/HH";
    public static final String DF_MM_DD_HH = "MM/dd HH";

    /**
     * mongo Collection Name
     */
    public static final String MONGO_PDCPORTID = "pdcportid";

    public static final String PORT_NAME_CHANGJIANGKOU = "长江口";

}
