package com.zthzinfo.shipservice.constants;

/**
 * @Desc : 关于实体类状态的标识常量
 * @Create : zhaoey ~ 2020/04/07
 */
public class EntityConstants {

    /**
     * port_ship_pdc.is_known
     * 0:未知，1：已知
     */
    public static final int PORTSHIPPDC_IS_KNOWN_UNKNOWN = 0;
    public static final int PORTSHIPPDC_IS_KNOWN_KNOWN = 1;

    /**
     * 船是否在工作
     */
    public static final int SHIP_IS_WORKING_UNKNOWN = 0; // 未知
    public static final int SHIP_IS_WORKING_NOLOAD = 1; // 空载
    public static final int SHIP_IS_WORKING_LOAD = 2; // 装载

    /**
     * ship_status
     */
    public static final int SHIP_STATUS_KAOBO = 0; // 靠泊计划
    public static final int SHIP_STATUS_ZAIMAO = 1; // 在锚船动态
    public static final int SHIP_STATUS_ZAIGANG = 2; // 在港船动态
    public static final int SHIP_STATUS_LIBO = 3;// 离泊计划
	public static final int SHIP_STATUS_JINGANG = 4; // 船舶预到
	public static final int SHIP_STATUS_CHUGANG = 5; // 船舶离港
    public static final int WEIZHI = 999; // 船舶离港


    /**
     * 删除状态 1：正常，2：已删除
     */
    public static final int DELFLAG_NORMAL = 1;
    public static final int DELFLAG_DELETE = 2;

    /**
     * status2
     */
    public static final int STATUS2_ZAIHANG = 0;
    public static final int STATUS2_MAOBO = 1;
    public static final int STATUS2_KAOBO = 5;

    /**
     * ship_change_record.flow_status
     * 0：船信息更新，
     * 1：长时间没有更新位置，
     * 2：已处理
     * 3: 忽略
     */
    public static final int SCR_FLOW_STATUS_UPDATE_INFO = 0;
    public static final int SCR_FLOW_STATUS_NOT_UPDATE_POSITION = 1;
    public static final int SCR_FLOW_STATUS_OK = 2;
    public static final int SCR_FLOW_STATUS_IGNORE = 3;
}
