package com.zthzinfo.shipservice.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author zhaoey
 * @since 2020-04-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class CustomShipPort extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 港口名称
     */
    private String name;

    /**
     * 首字母
     */
    private String fstLetter;

    /**
     * 拼音
     */
    private String pinyin;

    /**
     * 添加者
     */
    private Integer uid;

    /**
     * 所属城市
     */
    private Integer region;

    /**
     * 经度
     */
    private String pointX;

    /**
     * 纬度
     */
    private String pointY;

    /**
     * 1长江，2珠江，3大运河，4沿海，5渤海，6黄海，7东海 ，8南海，9长江支流
     */
    private Integer type;

    /**
     * 港口状态，1：正常。2删除
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Integer createTime;

    /**
     * 最后修改时间
     */
    private Integer updateTime;

    /**
     * 港口ID
     */
    private Integer portid;


}
