package com.zthzinfo.shipservice.entity;

import java.util.Date;

import com.zthzinfo.shipservice.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author weikk
 * @since 2019-07-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class FreightCalculation extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 运单ID
	 */
	private String id;

	/**
	 * 初始港Id
	 */
	private String initialport;

	/**
	 * 目的港Id
	 */
	private String destination;

	/**
	 * 用户Id
	 */
	private String userid;

	/**
	 * 装港时间
	 */
	private Double loadingtime;

	/**
	 * 卸港时间
	 */
	private Double unloadingtime;

	/**
	 * 航行时间
	 */
	private Double flighttime;

	/**
	 * 运费
	 */
	@TableField("Freight")
	private Double Freight;

	/**
	 * 运价
	 */
	private Double freightrate;

	/**
	 * 利润
	 */
	private Double profit;

	/**
	 * 初始港滞期费
	 */
	private Double startdemurragefee;

	/**
	 * 目的港滞期费
	 */
	private Double enddemurragefee;

	/**
	 * 初始港港务费
	 */
	private Double startportfee;

	/**
	 * 目的港港务费
	 */
	private Double endportfee;

	/**
	 * 初始进出港
	 */
	private Double startjcfee;

	/**
	 * 目的港进出港
	 */
	private Double endjcfee;

	/**
	 * 初始港港内移泊
	 */
	private Double startybfee;

	/**
	 * 目的港港内移泊
	 */
	private Double endybfee;

	/**
	 * 初始港保安费
	 */
	private Double startsecurityfee;

	/**
	 * 目的港保安费
	 */
	private Double endsecurityfee;

	/**
	 * 初始港停泊费
	 */
	@TableField("startMooringfee")
	private Double startMooringfee;

	/**
	 * 目的港停泊费
	 */
	@TableField("endMooringfee")
	private Double endMooringfee;

	/**
	 * 初始港拖轮费
	 */
	private Double starttugfee;

	/**
	 * 目的港拖轮费
	 */
	private Double endtugfee;

	/**
	 * 创建时间
	 */
	@TableField("createTime")
	private Date createTime;

	/**
	 * 更新时间
	 */
	@TableField("updateTime")
	private Date updateTime;

	/**
	 * 吨位
	 */
	@TableField("tonnage")
	private Double tonnage;
	/**
	 * 总支出费用
	 */
	@TableField("demurragefee")
	private Double demurragefee;
	/**
	 * 船舶费用
	 */
	@TableField("shipfee")
	private Double shipfee;
	/**
	 * 船舶类型
	 */
	@TableField("shiptype")
	private String shiptype;
	/**
	 * 油耗类型
	 */
	@TableField("oiltype")
	private String oiltype;
	/**
	 * 油耗费用
	 */
	@TableField("oilfee")
	private Double oilfee;
	/**
	 * 油耗费用
	 */
	@TableField("speed")
	private Double speed;
	/**
	 * 人工费用
	 */
	@TableField("laborcost")
	private Double laborcost;
	/**
	 * 初始港滞期时间
	 */
	@TableField("startdemurragetime")
	private Double startdemurragetime;

	/**
	 * 目的港滞期时间
	 */
	@TableField("enddemurragetime")
	private Double enddemurragetime;
	private Double totaloilfee;
	private Double totalportfee;
	private Double totalfixedfee;

	private String startportname;
	private String endportname;

	private Double returndays;

	private String ip;
	private String goodstype;
	private Integer	loadingtimecheck;
	private Integer unloadingtimecheck;
	private Integer	flighttimecheck;
	private Integer freightratecheck;
	private Integer returndayscheck;
	private Integer totaloilfeecheck;
	private Integer totalfixedfeecheck;
	private Integer laborcostcheck;
	private Integer  shipfeecheck;

}
