package com.zthzinfo.shipservice.entity;

import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author weikk
 * @since 2019-08-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ToString
public class NearbyPortLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private String id;

    private String shipId;

    /**
     * 航行状态
     */
    private String status;

    /**
     * 经度
     */
    private Float longitude;

    /**
     * 纬度
     */
    private Float latitude;

    /**
     * 吃水
     */
    private Float draft;

    /**
     * 时间
     */
    private Date postTime;

    /**
     * 附近港口
     */
    private String nearbyPort;

    /**
     * 日志记录标示
     */
    private String mark;

    /**
     * 容错过的状态
     * 1：锚泊
     * 5：靠泊
     */
    private String status2;

    /**
     * 船舶状态改变时间
     */
    private Date status2Time;


    /**
     * 创建日期
     */
    private Date createTime;

    private String createBy;

    private Date updateTime;

    private String updateBy;

    private String isDel;

    private String spare1;

    /**
     * 到达港id
     */
    private String spare2;

    /**
     * 锚地/泊位id
     */
    private String spare3;

    private String spare4;

    private String spare5;


}
