package com.zthzinfo.shipservice.entity;

import java.util.Date;
import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author wangn
 * @since 2020-03-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PdcLygshipinfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 中文船名
     */
    private String shipChineseName;

    /**
     * 国籍
     */
    private String country;

    /**
     * 呼号
     */
    private String imo;

    /**
     * 英文船名
     */
    private String shipEnglishName;

    /**
     * 长度
     */
    private Double length;

    /**
     * 宽度
     */
    private Double width;

    /**
     * 总吨
     */
    private Double grossTon;

    /**
     * 净吨
     */
    private Double netTon;

    /**
     * 载重吨
     */
    private Double weight;

    /**
     * 船舶类型
     */
    private String shipType;

    /**
     * 舱口数
     */
    private Double hatchCount;

    /**
     * 最大吃水
     */
    private Double maxDraught;

    /**
     * 公分吨
     */
    private Double centimeter;

    /**
     * 航速
     */
    private Double speed;

    /**
     * 建造年份
     */
    private String buildYear;

    /**
     * 船公司
     */
    private String shipCompany;

    /**
     * 进口航次
     */
    private String importVoyage;

    /**
     * 出口航次
     */
    private String exportVoyage;

    /**
     * 性质
     */
    private String xingzhi;

    /**
     * 来港
     */
    private String comePort;

    /**
     * 去港
     */
    private String goPort;

    /**
     * 内外贸
     */
    private String trade;

    /**
     * 进口吃水
     */
    private String importDraught;

    /**
     * 出口吃水
     */
    private String exportDraught;

    /**
     * 速/滞费
     */
    private Double demurrage;

    /**
     * 预计到港时间
     */
    private String estimateArriveTime;
    
    /**
     * 货名
     */
    private String goodsName;
    
    /**
     * 货物重量
     */
    private String goodsNum;
    
    /**
     * 创建时间
     */
    private Date createDate;
}
