package com.zthzinfo.shipservice.entity;

import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


import java.util.Date;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>
 *
 * </p>
 *
 * @author wangn
 * @since 2020-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PdcShip extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 船名
     */
    private String shipName;

    /**
     * 船长
     */
    private Double shipLength;

    /**
     * 内外贸
     */
    private String trade;

    /**
     * 货名
     */
    private String goodsName;

    /**
     * 货物重量
     */
    private String goodsNum;

    /**
     * 载重吨
     */
    private Double weight;

    /**
     * 预靠时间
     */
    private String planBerthTime;

    /**
     * 实靠泊位
     */
    private String actualBerth;

    /**
     * 作业状态
     */
    private String workingStatus;

    /**
     * 作业公司
     */
    private String workingCompany;

    /**
     * 船舶状态：0：靠泊计划 1：在锚船动态 2：在港船动态 3：离泊计划 4:船舶进出港计划
     */
    private Integer shipStatus;

    /**
     * 数据来源
     */
    private String dataSource;

    private String createBy;

    private Date createDate;

    private String delFlag;
    /**
     * 抵锚时间
     */
    private String anchorTime;
    /**
     * 靠泊时间
     */
    private String berthTime;
    /**
     * 船型
     */
    private String shipType;

    /**
     * 计划动态
     */
    private String planStatus;
    /**
     * 预计完工时间
     */
    private String estimateFinishTime;

    /**
     * 预离时间
     */
    private String planUnberthTime;

    /**
     * 备注
     */
    private String remark;
    /**
     * 国籍
     */
    private String country;

    /**
     * 船长/进/出吃水
     */
    private String shipInoutDraught;

    /**
     * 计划进港时间
     */
    private String planInportTime;
    /**
     * 计划出港时间
     */
    private String planOutportTime;
    /**
     * 船代
     */
    private String chuandai;
    /**
     * 性质
     */
    private String xingzhi;

    /**
     * 引水
     */
    private String diversion;


    /**
     * 进出报告
     */
    private String inoutReport;
    /**
     * 船呼号
     */
    private String imo;
    /**
     * 到港时间
     */
    private String arrivePortTime;
    /**
     * 进口货名
     */
    private String importGoodsName;
    /**
     * 进口载重
     */
    private String importWeight;
    /**
     * 进口累计
     */
    private String importTotal;
    /**
     * 出口货名
     */
    private String exportGoodsName;
    /**
     * 出口载重
     */
    private String exportWeight;
    /**
     * 出口累计
     */
    private String exportTotal;
    /**
     * 计划移泊时间
     */
    private String planShiftTime;
    /**
     * 计划移泊泊位
     */
    private String planShiftBerth;
    /**
     * 目的港
     */
    private String destinationPort;
    /**
     * 开工时间
     */
    private String startWorkTime;

    /**
     * 完工时间
     */
    private String finishWorkTime;
    /**
     * 离港时间
     */
    private String outportTime;
    /**
     * 船位
     */
    private String shipPosition;

    /**
     * 预抵时间
     */
    private String estimateArriveTime;


    /**
     * （曹妃甸港口数据）时间
     */
    private String cfdTime;


    /**
     * 船长船宽
     */
    private String shipLengthWidth;


    /**
     * （曹妃甸港口数据）载重吨
     */
    private String cfdWeight;


    /**
     * 手续
     */
    private String procedures;

    /**
     * 配载
     */
    private String peizai;
    /**
     * 预计抵港位置
     */
    private String arrivePortPosition;
    /**
     * 计划靠泊时间
     */
    private String planBetchTime;
    /**
     * 计划靠泊位置
     */
    private String planBetchPosition;
    /**
     * 进港吃水
     */
    private Double inportDraught;
    /**
     * 进港引航
     */
    private String inportPilotage;
    /**
     * 离港吃水
     */
    private Double outportDraught;
    /**
     * 移离引航
     */
    private String outportPilotage;
    /**
     * 船舶朝向
     */
    private String shipOrientation;
    /**
     * 英文名字
     */
    private String shipEnglishName;
    /**
     * 配工
     */
    private String peigong;
    /**
     * 已装载
     */
    private Double loadNum;
    /**
     * 未装载
     */
    private Double preloadNum;
    /**
     * 开舱
     */
    private Double hatchCount;
    /**
     * 船舶流向
     */
    private String flowDirection;
    /**
     * 待泊状态
     */
    private String planBerthStatus;
    /**
     * 是否锚代理
     */
    private String isAnchor;
    /**
     * 排水时间
     */
    private String dewaterTime;
    /**
     * 手续办理时间
     */
    private String handleProceduresTime;

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        String a = Optional.ofNullable(goodsName).map(String::trim).orElse("");
        this.goodsName = a;
    }

    public String getShipType() {
        return shipType;
    }

    public void setShipType(String shipType) {
        String a = Optional.ofNullable(shipType).map(String::trim).orElse("");
        this.shipType = a;
    }
    @Override
    public boolean equals(Object o){
        if(o==null){
            return false;
        }
        if(o instanceof PdcShip){
            PdcShip p=(PdcShip)o;
            return Objects.equals(shipName,p.getShipName());
        }
        return false;
    }
}
