package com.zthzinfo.shipservice.entity;

import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author wangn
 * @since 2020-03-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PdcYkgshipinfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 理货单位
     */
    private String tallyCompany;

    /**
     * 船名
     */
    private String shipName;

    /**
     * 单位
     */
    private String company;

    /**
     * 船主
     */
    private String shipOwner;

    /**
     * 国籍
     */
    private String country;

    /**
     * 船长
     */
    private Double length;

    /**
     * 船类型
     */
    private String shipType;

    /**
     * 载重吨
     */
    private Double weight;

    /**
     * 派船方
     */
    private String dispatching;

    /**
     * 航次
     */
    private String voyage;

    /**
     * 速谴
     */
    private String quickDispatchq;

    /**
     * 来港
     */
    private String comePort;

    /**
     * 代理
     */
    private String daili;

    /**
     * 泊位
     */
    private String berth;

    /**
     * 往港
     */
    private String goPort;

    /**
     * 内外贸
     */
    private String trade;

    /**
     * 航线
     */
    private String route;

    /**
     * 出口货名
     */
    private String exportGoodsName;

    /**
     * 船舶性质
     */
    private String chuanboxingzhi;

    /**
     * 舱口数
     */
    private Double hatchCount;

    /**
     * 预抵时间
     */
    private String estimateArriveTime;

    /**
     * 抵锚时间
     */
    private String anchorTime;

    /**
     * 靠泊时间
     */
    private String berthTime;

    /**
     * 到港头吃水
     */
    private Double headDraught;

    /**
     * 中吃水
     */
    private Double middleDraught;

    /**
     * 尾吃水
     */
    private Double tailDraught;

    /**
     * 东经
     */
    private Double eastLng;

    /**
     * 北纬
     */
    private Double northLat;

    /**
     * 实际装货
     */
    private String actualUpload;

    /**
     * 实际卸货
     */
    private String actualDownload;

    /**
     * 上油量
     */
    private String oilLoading;

    /**
     * 上水量
     */
    private String waterLoading;

    /**
     * 吊杆负荷
     */
    private String diaoganfuhe;
    
    private Date createDate;
}
