package com.zthzinfo.shipservice.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
* <p>
    * 
    * </p>
*
* @author weikk
* @since 2019-07-26
*/
    @Data
        @EqualsAndHashCode(callSuper = true)
    @Accessors(chain = true)
    public class PortDistance extends BaseEntity {

    private static final long serialVersionUID = 1L;

            @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

            /**
            * 港口id组合,例如:(500,501)(501,500)
            */
    private String port;

            /**
            * 参考距离
            */
    private Integer distance;

            /**
            * 参考金额
            */
    private Integer money;

            /**
            * 创建时间
            */
    private Integer createtime;

            /**
            * 来源   1   原始的   2   使用新方法添加的
            */
    private String source;

            /**
            * 途经坐标记录（可以将次记录去 http://lbs.amap.com/api/javascript-api/example/overlayers/draw-ground-line）变成路线
            */
    private String lineCoordinate;


}
