package com.zthzinfo.shipservice.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author yzg
 * @since 2020-04-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PortShipPdc extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 港口ID
     */
    private Integer portId;

    private String portName;
    /**
     * 内外贸
     */
    private String trade;
    /**
     * 船ID
     */
    private String shipId;

    /**
     * 未知船ID
     */
    private String shipUnknownId;

    private String pdcShipId;

    /**
     * 是否为已知船.1:已知，0：未知
     */
    private Integer isKnown;

    private Date createTime;

    private Date updateTime;

    /**
     * 船舶状态。
     * 0:抵港
     * 1：锚泊-等泊
     * 2：待靠
     * 3：前往靠泊
     * 4：已靠波
     * 5：靠泊-作业中
     * 6：靠泊-待离泊
     * 7：已离港
     */
    private Integer shipStatus;

    private String updateBy;

    /**
     * 预靠时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String planBerthTime;

    /**
     * 抵锚时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String anchorTime;

    /**
     * 靠泊时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String berthTime;

    /**
     * 预离时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String planUnberthTime;

    /**
     * 计划进港时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String planInportTime;

    /**
     * 计划出港时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String planOutportTime;

    /**
     * 到港时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String arrivePortTime;

    /**
     * 离港时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String outportTime;

    /**
     * 预抵时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String estimateArriveTime;

    /**
     * 计划靠泊时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String planBetchTime;

    /**
     * 预计完工时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String estimateFinishTime;

    /**
     * （曹妃甸港口数据）时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String cfdTime;

    private String shipMmsi;

//    @TableField(strategy = FieldStrategy.IGNORED)
    private Integer portAreaId;

//    @TableField(strategy = FieldStrategy.IGNORED)
    private Integer startPortId;

//    @TableField(strategy = FieldStrategy.IGNORED)
    private String startPortName;

    /**
     * 工作备注
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String workRemark;

    /**
     * 开工时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String startWorkTime;

    /**
     * 完工时间
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String finishWorkTime;

    /**
     * 实靠泊位
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String actualBerth;

    /**
     * 预计抵港位置
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String arrivePortPosition;

    /**
     * 计划靠泊位置
     */
//    @TableField(strategy = FieldStrategy.IGNORED)
    private String planBetchPosition;
    /**
     * 船舶类型
     */
    private String shipType;
}
