package com.zthzinfo.shipservice.entity;

import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author yzg
 * @since 2020-04-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PortShipPdcTrack extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 港口ID
     */
    private Integer portId;

    private String portName;

    /**
     * 船ID
     */
    private String shipId;

    /**
     * 未知船ID
     */
    private String shipUnknownId;

    private String pdcShipId;

    /**
     * 是否为已知船.1:已知，0：未知
     */
    private Integer isKnown;

    private Date createTime;

    private Date updateTime;

    /**
     * 船舶状态。
     * 0：靠泊计划 1：在锚船动态 2：在港船动态 3：离泊计划 4:船舶进出港计划
     */
    private Integer shipStatus;

    private String updateBy;

    /**
     * 预靠时间
     */
    private String planBerthTime;

    /**
     * 抵锚时间
     */
    private String anchorTime;

    /**
     * 靠泊时间
     */
    private String berthTime;

    /**
     * 预离时间
     */
    private String planUnberthTime;

    /**
     * 计划进港时间
     */
    private String planInportTime;

    /**
     * 计划出港时间
     */
    private String planOutportTime;

    /**
     * 到港时间
     */
    private String arrivePortTime;

    /**
     * 离港时间
     */
    private String outportTime;

    /**
     * 预抵时间
     */
    private String estimateArriveTime;

    /**
     * 计划靠泊时间
     */
    private String planBetchTime;

    /**
     * 预计完工时间
     */
    private String estimateFinishTime;

    /**
     * （曹妃甸港口数据）时间
     */
    private String cfdTime;

    private String shipMmsi;

    private Integer portAreaId;

    private String portShipPdcId;
}
