package com.zthzinfo.shipservice.entity;

    import java.time.LocalDateTime;
    import java.util.Date;

    import com.zthzinfo.shipservice.base.BaseEntity;
    import lombok.Data;
    import lombok.EqualsAndHashCode;
    import lombok.experimental.Accessors;

/**
* <p>
    * 
    * </p>
*
* @author yangzg
* @since 2019-11-14
*/
    @Data
        @EqualsAndHashCode(callSuper = true)
    @Accessors(chain = true)
    public class RoutePlan extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private String id;

    private String sid;

            /**
            * 根据code查询订单情况
            */
    private String code;

            /**
            * 计划装载时间
            */
    private Date plannedLoadingTime;

            /**
            * 计划送达时间
            */
    private Date scheduledDeliveryTime;

            /**
            * 计划装载货物
            */
    private String plannedLoad;

            /**
            * 计划装载吨位
            */
    private Float plannedTonnage;

            /**
            * 装载港id
            */
    private String loadPortId;

            /**
            * 装载港锚地id
            */
    private String loadingPortAnchorageId;

            /**
            * 装载港泊位id
            */
    private String loadingPortBerthId;

            /**
            * 卸载港id
            */
    private String dischargePortId;

            /**
            * 卸载港锚地id
            */
    private String dischargePortAnchorageId;

            /**
            * 卸载港泊位id
            */
    private String dischargePortBerthId;

            /**
            * 前往装载港时间
            */
    private Date timeToLoadingPort;

            /**
            * 前往装载港时位置
            */
    private String positionLoadingPort;

            /**
            * 前往装载港时吃水
            */
    private Float draughtLoadingPort;

            /**
            * 抵达装载港时间
            */
    private Date timeArrivalLoadingPort;

            /**
            * 抵达装载港时位置
            */
    private String positionArrivalLoadingPort;

            /**
            * 抵达装载港时吃水
            */
    private Float draughtArrivalLoadingPort;

            /**
            * 靠泊装载港时间
            */
    private Date timeBerthingLoadingPort;

            /**
            * 靠泊装载港时位置
            */
    private String positionBerthLoadingPort;

            /**
            * 靠泊装载港时吃水
            */
    private Float draughtBerthLoadingPort;

            /**
            * 离泊装载港时间
            */
    private Date timeDepartureLoadingPort;

            /**
            * 离泊装载港时位置
            */
    private String positionDepartureLoadingPort;

            /**
            * 离泊装载港时吃水
            */
    private Float draughtDepartureLoadingPort;

            /**
            * 抵达卸载港时间
            */
    private Date timeArrivalDischargePort;

            /**
            * 抵达卸载港时位置
            */
    private String positionArrivalDischargePort;

            /**
            * 抵达卸载港时吃水
            */
    private Float draughtArrivalDischargePort;

            /**
            * 靠泊卸载港时间
            */
    private Date timeBerthingDischargePort;

            /**
            * 靠泊卸载港时位置
            */
    private String positionBerthingDischargePort;

            /**
            * 靠泊卸载港时吃水
            */
    private Float draughtBerthingDischargePort;

            /**
            * 离泊卸载港时间
            */
    private Date timeDepartureDischargePort;

            /**
            * 离泊卸载港时位置
            */
    private String positionDepartureDischargePort;

            /**
            * 离泊卸载港时吃水
            */
    private Float draughtDepartureDischargePort;

    private Date createTime;

    private String createBy;

    private Date updateTime;

    private String updateBy;

    private String delFlag;

    private String spare1;

    private String spare2;

    private String spare3;

    private String spare4;

    private String spare5;


}
