package com.zthzinfo.shipservice.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @Desc :
 * @Create : zhaoey ~ 2020/05/06
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ShipChangeRecord extends BaseEntity {

    private String id;
    private String mmsi;
    private String shipId;

    /**
     * 船名（英文）
     */
    private String shipName;
    /**
     * 船名（中文）
     */
    private String shipNameCn;
    /**
     * 船舶呼号
     */
    private String callsign;
    /**
     * 船舶代码
     */
    private Integer imo;
    /**
     * 船舶类型 默认：散货船20
     */
    private String shipType;
    /**
     * 船高
     */
    private Float shipLength;
    /**
     * 船宽
     */
    private Float shipWeight;

    /**
     * 备注：改变原因
     */
    private String remark;
    /**
     * 改变的字段
     */
    private String changeField;
    /**
     * 状态：0：船信息更新，1：长时间没有更新位置，2：已处理
     */
    private Integer flowStatus;

    private Integer delFlag;
    private String createBy;
    private Date createTime;
    private String updateBy;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    private static final long serialVersionUID = -7478845355130990956L;
}
