package com.zthzinfo.shipservice.entity;


import java.util.Date;

import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author yangzg
 * @since 2019-12-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ShipLine extends BaseEntity {

	private static final long serialVersionUID = 1L;

	private String id;

	private String mmsi;

	/**
	 * 起始港
	 */
	private String startPort;

	/**
	 * 起始港名称
	 */
	private String startPortName;

	/**
	 * 目的港
	 */
	private String endPort;

	/**
	 * 目的港名称
	 */
	private String endPortName;

	/**
	 * 货物
	 */
	private String goods;

	/**
	 * 货物吨数
	 */
	private String tonGoods;

	/**
	 * 货物种类(一般钢材，32吨钢卷)
	 */
	private String typeGoods;

	/**
	 * 货主
	 */
	private String huozhuName;

	/**
	 * 货主联系方式
	 */
	private String huozhuMobile;

	/**
	 * 订货人
	 */
	private String dinghuoren;

	/**
	 * 订货人联系方式
	 */
	private String dinghuorenMobile;

	/**
	 * 船东业务人
	 */
	private String chuandongyewuren;

	/**
	 * 船东业务人联系方式
	 */
	private String chuandongyewurenMobile;

	/**
	 * 起始港锚泊时间
	 */
	private Date startPortAnchoringTime;

	/**
	 * 起始港锚地
	 */
	private String startPortAnchorageGround;

	/**
	 * 起始港靠泊时间
	 */
	private Date startPortBerthingTime;

	/**
	 * 起始港泊位
	 */
	private String startPortBerth;

	/**
	 * 目的港锚泊时间
	 */
	private Date endPortAnchoringTime;

	/**
	 * 目的港锚地
	 */
	private String endPortAnchorageGround;

	/**
	 * 目的港靠泊时间
	 */
	private Date endPortBerthingTime;

	/**
	 * 目的港泊位
	 */
	private String endPortBerth;

	private Date createTime;

	private String cteateBy;

	private Date updateTime;

	private String updateBy;
	/**
	 * 离港时间
	 */
	private String spare1;

	private String spare2;

	private String spare3;

	private String spare4;

	private String spare5;

	private String spare6;

	private String spare7;

	private String spare8;

	private String spare9;

	private String spare10;

	private String spare11;

	private String spare12;

	private String spare13;

	private String spare14;

	private String spare15;

	private String spare16;

	private String spare17;

	private String spare18;

	private String spare19;

	private String spare20;


}
