package com.zthzinfo.shipservice.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author sungf
 * @since 2019-07-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ShipPort extends BaseEntity {

	private static final long serialVersionUID = 1L;
	public ShipPort(){
		super();
	}
	public ShipPort(Integer id){
		super();
		this.id=id;
	}

	@TableId(value = "id", type = IdType.AUTO)
	private Integer id;

	/**
	 * 操作人uid
	 */
	private String name;

	/**
	 * 港口首字母
	 */
	private String fstLetter;

	/**
	 * 港口全拼
	 */
	private String pinyin;

	/**
	 * 所属城市
	 */
	private Integer region;

	/**
	 * 新浪天气查询名称
	 */
	private String sinaWeatherCode;

	/**
	 * 是否开通1：开通 0：未开通
	 */
	private Integer isOpen;

	/**
	 * 经度
	 */
	private String pointX;

	/**
	 * 纬度
	 */
	private String pointY;

	/**
	 * 港口类型类型 1:内河 2:沿海
	 */
	private Integer type;

	/**
	 * 排序
	 */
	private Integer sort;

	/**
	 * 类型 默认空（区域） 港口（port ）
	 */
	private String model;

	/**
	 * 区域id
	 */
	private Integer areaId;

	/**
	 * 该港口是否在首页上可以被点击  0 不可以  1 可以
	 */
	private Integer showInfoType;

	/**
	 * 北方港口推荐匹配时到达的天数期限(单位：小时)
	 */
	private Integer northRecommendDay;

	private String portarea;
	private String portareaname;

	private String nearDistance;

	private String arrivalDistance;

	private String delFlag;

	@TableField(exist = false)
	private Double km ;

	public ShipPort(Integer id, String name) {
		this.id = id;
		this.name = name;
	}
}
