package com.zthzinfo.shipservice.entity;

import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
* <p>
    *
    * </p>
*
* @author weikk
* @since 2019-07-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ShipSnapshot extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 2781768979793459438L;
	private String id;

	private String shipId;

	/**
	 * 船舶经度
	 */
	private Float longitude;

	/**
	 * 船舶维度
	 */
	private Float latitude;

            /**
            * 船舶吃水
            */
    private Float drainage;

            /**
            * 船舶运行状态。0：停泊。1：航行中
            */
    private Integer status;

            /**
            * 附近的港口code
            */
    private String nearbyPort;

            /**
            * 到达港口code
            */
    private String portOfArrival;

            /**
            * 船舶当前航速
            */
    private Float speed;

            /**
            * 最后更新时间
            */
    private Date lastUpdateTime;

            /**
            * 创建日期
            */
    private Date createTime;

    private String createBy;

    private Date updateTime;

    private String updateBy;

    private String isDel;

    private String mmsi;
	private String destPort; // 目的港
	private Integer destPortId; // 目的港
    private String etatime; // 预到达时间
    private Integer status2; //
    private Date status2Time;

    private String groundId;

    private String emptyOverloadState;

    private Date  emptyOverloadStateUpdateTime;

    private String loadingOrUnloading;

    private String course;

    private String heading;
}
