package com.zthzinfo.shipservice.entity;

import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
* <p>
    *
    * </p>
*
* @author weikk
* @since 2019-07-23
*/
    @Data
        @EqualsAndHashCode(callSuper = true)
    @Accessors(chain = true)
    public class ShipSnapshotTmp extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private String id;

    private String shipId;

            /**
            * 船舶经度
            */
    private Float longitude;

            /**
            * 船舶维度
            */
    private Float latitude;

            /**
            * 船舶吃水
            */
    private Float drainage;

            /**
            * 船舶运行状态。0：停泊。1：航行中
            */
    private Integer status;

            /**
            * 附近的港口code
            */
    private String nearbyPort;

            /**
            * 到达港口code
            */
    private String portOfArrival;

            /**
            * 船舶当前航速
            */
    private Float speed;

            /**
            * 最后更新时间
            */
    private LocalDateTime lastUpdateTime;

            /**
            * 创建日期
            */
    private LocalDateTime createTime;

    private String createBy;

    private LocalDateTime updateTime;

    private String updateBy;

    private String isDel;

    private String groundId;


}
