package com.zthzinfo.shipservice.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * 运单船舶定位跟踪
 * </p>
 *
 * @author sungf
 * @since 2019-05-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ToString
public class ShipTrack extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableId(value = "id", type = IdType.INPUT)
	private String id;

	private String shipId;

	/**
	 * mmsi号
	 */
	private String mmsi;

	/**
	 * 经度
	 */
	private String longitude;

	/**
	 * 纬度
	 */
	private String latitude;

	/**
	 * 航向
	 */
	private String course;

	/**
	 * 航速
	 */
	private String speed;

	/**
	 * 距离
	 */
	private Double distance;

	private Long postime;

	private Date createTime;

	/**
	 * 经过港
	 */
	private String scanPort;

	/**
	 * 目的港
	 */
	private String destPort;

	/**
	 * 预到目的港时间
	 */
	private String etatime;

	/**
	 * 吃水
	 */
	private Float draught;

	private String navStatus;

	private String heading;
	/**
	 * nearby_port_log.status2
	 */
	@TableField(exist = false)
	private String status2;

}
