package com.zthzinfo.shipservice.entity;

import com.zthzinfo.shipservice.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author yzg
 * @since 2020-04-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ShipUnknown extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private String id;

    private String shipMmsi;

    private String shipName;

    private String shipNameChinese;

    /**
     * 船高
     */
    private Float shipLength;

    /**
     * 船宽
     */
    private Float shipWeight;

    /**
     * 船舶呼号
     */
    private String callsign;

    /**
     * 船舶代码
     */
    private String imo;

    /**
     * 船舶类型 默认：散货船20
     */
    private Integer shipType;

    /**
     * 载重量
     */
    private Integer deadWeight;

    /**
     * 吃水
     */
    private Float draught;

    /**
     * 描述
     */
    private String dest;

    /**
     * 是否在工作 0 未知 1 空载 2装载
     */
    private Integer isWorking;

    /**
     * 船舶注册时间
     */
    private Integer registtime;

    /**
     * 船舶英文名
     */
    private String shipEname;

    /**
     * 0:在航,1:锚泊,5:靠泊
     */
    private Integer navStatus;

    /**
     * 目的港
     */
    private String destPort;

    /**
     * 预到目的港时间
     */
    private String etatime;

    /**
     * 船速(单位节)
     */
    private String speed;

    /**
     * 状态更新时间
     */
    private Integer sptime;

    /**
     * 船高
     */
    private Float shipHeight;

    private Integer delTime;

    private String createBy;

    private Date createTime;

    private String updateBy;

    private Date updateTime;

    private Integer spare1;
    private Double spare2;
    private String spare3;
    private String spare4;
    private String spare5;

}
