package com.zthzinfo.shipservice.enums;


public enum EmptyOverloadStateEnum {

	EMPTY("0", "空载"),
	OVERLOAD("5", "重载"),
	UNKNOWN("10", "未知");

	private String code;
	private String value;

	EmptyOverloadStateEnum(String code, String value) {
		this.code = code;
		this.value = value;
	}
	public static String paserValue(String code){
		if (code==null){
			return null;
		}
		for (EmptyOverloadStateEnum typeEnum: EmptyOverloadStateEnum.values()){
			if(code.equals(typeEnum.getCode())){
				return typeEnum.getValue();
			}
		}
		return null;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
}
