package com.zthzinfo.shipservice.enums;


public enum ShipStatusEnum {

	UNDERWAY(0, "在航"),
	LIE_AT_ANCHOR(1, "锚泊"),
	ANCHOR_ALONG_SHORE(5, "靠泊");

	private Integer code;
	private String value;

	ShipStatusEnum(Integer code, String value) {
		this.code = code;
		this.value = value;
	}
	public static String paserValue(Integer code){
		if (code==null){
			return null;
		}
		for (ShipStatusEnum typeEnum: ShipStatusEnum.values()){
			if(code.equals(typeEnum.getCode())){
				return typeEnum.getValue();
			}
		}
		return null;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
}
