package com.zthzinfo.shipservice.enums;


import cn.hutool.core.util.StrUtil;

public enum ShipTypeEnum {

	//其他类型船舶
	OTHER(999, "其他"),


	ZHAHUO(10, "杂货船"),
	SHANHUO(20, "散货船"),
	JIZHUANGXIANG(30, "集装箱船"),
	GUNZHUANG(40, "滚装船"),
	ZAIBO(50, "载驳船"),
	YOU(60, "油船"),
	YEHUAQI(70, "液化气船"),
	LENGCHANG(80, "冷藏船"),
	JIAYOU(90, "加油船"),
	JIAYOUBO(100, "加油驳船"),


	YINHANG(110, "引航船"),
	SHOUJIU(120, "搜救船"),
	TUOLUN(130, "拖轮船"),
	GANGKOUGONGYING(140, "港口供应船"),
	FANGWENRAN(150, "载有防污染装置和设备的船舶"),
	ZHIFA(160, "执法艇"),
	BEIYONG(170, "备用-用于当地船舶的任务分配"),
	YILIAO(180, "医疗船"), //（如 1949 年日内瓦公约及附加条款所规定）
	JUEYI18(190, "18号决议船"), //符合 18 号决议（Mob-83）的船舶
	PULAO(200, "捕捞船"),
	TUOYIN(210, "拖引船"),
	DATUOYIN(220, "大托引船"), //拖引并且船长>200m 或船宽>25m
	SHUJUN(230, "疏浚或水下作业船"),
	QIANSHUI(240, "潜水作业船"),
	JUNSHI(250, "军事行动船"),
	FANCHUAN(260, "帆船航行船"),
	YULE(270, "娱乐船"),
	DIXIAO(280, "地效应船"),
	GAOSHU(290, "高速船"),
	KECHUAN(300, "客船");





	private Integer code;
	private String value;

	ShipTypeEnum(Integer code, String value) {
		this.code = code;
		this.value = value;
	}
	public static String paserValue(Integer code){
		if (code==null){
			return null;
		}
		for (ShipTypeEnum typeEnum: ShipTypeEnum.values()){
			if(code.equals(typeEnum.getCode())){
				return typeEnum.getValue();
			}
		}
		return null;
	}
	public static Integer paserCode(String value){
		if(StrUtil.isBlank(value)){
			return null;
		}
		for (ShipTypeEnum typeEnum: ShipTypeEnum.values()){
			if(value.equals(typeEnum.getValue())){
				return typeEnum.getCode();
			}
		}
		return null;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
}
