package com.zthzinfo.shipservice.model;

import com.zthzinfo.common.ResponseMapBuilder;
import com.zthzinfo.shipservice.constants.BaseConstants;

import java.util.Map;

/**
 * @Desc :
 * @Create : zhaoey ~ 2020/04/16
 */
public class ResponseMapWrapperBuilder {

    public static Map<String,Object> ok(){
        return ResponseMapBuilder.newBuilder().putSuccess().getResult();
    }

    public static Map<String,Object> ok(String msg){
        return ResponseMapBuilder.newBuilder().putSuccess()
                .put("resultMsg",msg)
                .getResult();
    }

    public static Map<String,Object> data(Object data){
        return dataBuilder(data)
                .getResult();
    }

    public static ResponseMapBuilder dataBuilder(Object data){
        return put(BaseConstants.RESPONSE_DATA,data);
    }

    public static ResponseMapBuilder put(String key,Object value){
        return ResponseMapBuilder.newBuilder().putSuccess()
                .put(key,value);
    }
}
