package com.zthzinfo.shipservice.model.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @Desc :
 * @Create : zhaoey ~ 2020/05/06
 */
@Data
public class ShipInfoDto implements Serializable {

    /**
     * 船名（英文）
     */
    private String shipName;
    /**
     * 船名（中文）
     */
    private String shipNameCn;
    /**
     * 船舶呼号
     */
    private String callSign;
    /**
     * 船舶代码
     */
    private Integer imo;
    /**
     * 船舶类型 默认：散货船20
     */
    private String shipType;
    /**
     * 船高
     */
    private Float shipLength;
    /**
     * 船宽
     */
    private Float shipWeight;

    private Integer left;

    private Integer trail;

    private static final long serialVersionUID = 361322517748584649L;
}
