package com.zthzinfo.shipservice.model.vo;

import com.zthzinfo.shipservice.entity.ShipSnapshot;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class ShipDynamicVoForPlanBerth {

    /**
     * 船舶mmsi
     */
    private String shipMmsi;
    /**
     * 船名
     */
    private String shipName;
    /**
     * 吨位
     */
    private Integer deadWeight;
    /**
     * 船舶状态
     */
    private Integer status2;
    /**
     * 抵港时间
     */
    private String digangTime;
    /**
     * 港口名称
     */
    private String portName;
    /**
     * 离泊时间
     */
    private String liboTime;
    /**
     * 靠泊时间
     */
    private String kaoboTime;
    /**
     * 预抵时间
     */
    private String yudiTime;
    /**
     * 预计靠泊时间
     * MM/dd
     */
    private String yjkbTime;
    /**
     * 目的港口
     */
    private String destPortName;
    /**
     * 预计离泊时间
     * MM/dd
     */
    private String yjlbTime;
    /**
     * 工作状态
     */
    private String workingStatus;
    /**
     * 开工时间
     */
    private String startWorkTime;
    /**
     * 完工时间
     */
    private String finishWorkTime;
    /**
     * 起始港名字
     */
    private String startPortName;
    /**
     * 未知船id
     */
    private String shipUnknownId;

    private Integer destPortId;

    private Integer portId;

    private Integer startPortId;

    /**
     * 实际靠泊位置
     */
    private String actualBerth;

    /**
     * 预计锚泊位置
     */
    private String arrivePortPosition;
    /**
     * 计划靠泊位置
     */
    private String planBetchPosition;

    private String emptyOrNotEmpty;


    private String status2Time;

    private String nowPosition;

    private Integer nowPositionId;
}
