package com.zthzinfo.utils.idgen;

import com.robert.vesta.service.impl.IdServiceImpl;
import com.robert.vesta.service.impl.bean.IdMeta;
import com.robert.vesta.service.impl.bean.IdType;
import com.robert.vesta.service.impl.provider.PropertyMachineIdProvider;
import com.robert.vesta.service.intf.IdService;

public class VestaId {

	public static Integer idServiceMachineId = 1;

	private static IdService idService;
	public static IdService getIdService() {
		if (idService == null) {
			synchronized (VestaId.class) {
				if (idService == null) {
					PropertyMachineIdProvider propertyMachineIdProvider = new PropertyMachineIdProvider();
					propertyMachineIdProvider.setMachineId(idServiceMachineId);
					idService = new IdServiceImpl();
					((IdServiceImpl)idService).setMachineIdProvider(propertyMachineIdProvider);
					((IdServiceImpl)idService).init();
				}
			}
		}

		return idService;
	}

	public synchronized static String newId() {
		return getIdService().genId() + "";
	}
}
