/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.MutableContext;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MutableMapContext
extends MapContext
implements MutableContext {
    public MutableMapContext(Map<String, String> options) {
        super(options);
    }

    public MutableMapContext() {
        this(new HashMap<String, String>());
    }

    @Override
    public void setString(String key, String value) {
        this.getOptions().put(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.getOptions().put(key, Long.toString(value));
    }

    @Override
    public void setInteger(String key, int value) {
        this.getOptions().put(key, Integer.toString(value));
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.getOptions().put(key, Boolean.toString(value));
    }

    @Override
    public void setAll(Map<String, String> map) {
        if (map == null) {
            return;
        }
        this.getOptions().putAll(map);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.getOptions().entrySet().iterator();
    }
}

