/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.LinkedList;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.error.code.SqoopError;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.utils.ClassUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ThrowableBean
implements JsonBean {
    public static final String MESSAGE = "message";
    public static final String STACK_TRACE = "stack-trace";
    public static final String CLASS = "class";
    public static final String METHOD = "method";
    public static final String FILE = "file";
    public static final String LINE = "line";
    public static final String CAUSE = "cause";
    public static final String ERROR_CODE = "error-code";
    public static final String ERROR_CODE_MESSAGE = "error-code-message";
    private Throwable throwable;

    public ThrowableBean(Throwable ex) {
        this.throwable = ex;
    }

    public ThrowableBean() {
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject result = new JSONObject();
        result.put((Object)MESSAGE, (Object)this.throwable.getMessage());
        result.put((Object)CLASS, (Object)this.throwable.getClass().getName());
        if (this.throwable instanceof SqoopException) {
            SqoopException sqoopException = (SqoopException)this.throwable;
            result.put((Object)ERROR_CODE, (Object)sqoopException.getErrorCode().getCode());
            result.put((Object)ERROR_CODE_MESSAGE, (Object)sqoopException.getErrorCode().getMessage());
            result.put((Object)MESSAGE, (Object)sqoopException.getOriginalMessage());
        }
        JSONArray st = new JSONArray();
        for (StackTraceElement element : this.throwable.getStackTrace()) {
            JSONObject obj = new JSONObject();
            obj.put((Object)CLASS, (Object)element.getClassName());
            obj.put((Object)METHOD, (Object)element.getMethodName());
            obj.put((Object)FILE, (Object)element.getFileName());
            obj.put((Object)LINE, (Object)element.getLineNumber());
            st.add((Object)obj);
        }
        result.put((Object)STACK_TRACE, (Object)st);
        Throwable cause = this.throwable.getCause();
        if (cause != null) {
            ThrowableBean causeBean = new ThrowableBean(cause);
            result.put((Object)CAUSE, (Object)causeBean.extract(skipSensitive));
        }
        return result;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        String exceptionClass = (String)jsonObject.get((Object)CLASS);
        String message = (String)jsonObject.get((Object)MESSAGE);
        if (message == null) {
            message = "";
        }
        if (jsonObject.containsKey((Object)ERROR_CODE)) {
            String errorCode = (String)jsonObject.get((Object)ERROR_CODE);
            String errorCodeMessage = (String)jsonObject.get((Object)ERROR_CODE_MESSAGE);
            SqoopError code = new SqoopError(errorCode, errorCodeMessage);
            this.throwable = (Throwable)ClassUtils.instantiate(exceptionClass, code, message);
        }
        if (this.throwable == null) {
            this.throwable = (Throwable)ClassUtils.instantiate(exceptionClass, message);
        }
        if (this.throwable == null) {
            this.throwable = new Throwable(message);
        }
        LinkedList<StackTraceElement> st = new LinkedList<StackTraceElement>();
        for (Object object : (JSONArray)jsonObject.get((Object)STACK_TRACE)) {
            JSONObject json = (JSONObject)object;
            StackTraceElement element = new StackTraceElement((String)json.get((Object)CLASS), (String)json.get((Object)METHOD), (String)json.get((Object)FILE), ((Long)json.get((Object)LINE)).intValue());
            st.add(element);
        }
        this.throwable.setStackTrace(st.toArray(new StackTraceElement[0]));
        Object cause = jsonObject.get((Object)CAUSE);
        if (cause != null) {
            JSONObject causeJson = (JSONObject)cause;
            ThrowableBean causeBean = new ThrowableBean();
            causeBean.restore(causeJson);
            this.throwable.initCause(causeBean.getThrowable());
        }
    }
}

