/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.validation.ConfigValidationResult;
import org.apache.sqoop.validation.Message;
import org.apache.sqoop.validation.Status;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ValidationResultBean
implements JsonBean {
    private static final String VALIDATION_RESULT = "validation-result";
    private static final String STATUS = "status";
    private static final String MESSAGE = "message";
    private ConfigValidationResult[] results;
    private String name;

    public ValidationResultBean() {
    }

    public ValidationResultBean(ConfigValidationResult ... results) {
        this.results = results;
    }

    public ConfigValidationResult[] getValidationResults() {
        if (this.results == null) {
            return new ConfigValidationResult[0];
        }
        return (ConfigValidationResult[])this.results.clone();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray array = new JSONArray();
        for (ConfigValidationResult result : this.results) {
            JSONObject output = this.extractValidationResult(result);
            array.add((Object)output);
        }
        JSONObject object = new JSONObject();
        object.put((Object)VALIDATION_RESULT, (Object)array);
        if (this.name != null) {
            object.put((Object)"name", (Object)this.name);
        }
        return object;
    }

    private JSONObject extractValidationResult(ConfigValidationResult result) {
        JSONObject ret = new JSONObject();
        for (Map.Entry<String, List<Message>> entry : result.getMessages().entrySet()) {
            ret.put((Object)entry.getKey(), this.extractMessageList(entry.getValue()));
        }
        return ret;
    }

    private Object extractMessageList(List<Message> messages) {
        JSONArray array = new JSONArray();
        for (Message message : messages) {
            array.add(this.extractMessage(message));
        }
        return array;
    }

    private Object extractMessage(Message message) {
        JSONObject ret = new JSONObject();
        ret.put((Object)STATUS, (Object)message.getStatus().toString());
        ret.put((Object)MESSAGE, (Object)message.getMessage());
        return ret;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        JSONArray array = JSONUtils.getJSONArray(jsonObject, VALIDATION_RESULT);
        this.results = new ConfigValidationResult[array.size()];
        int i = 0;
        for (Object item : array) {
            this.results[i++] = this.restoreValidationResult((JSONObject)item);
        }
        if (jsonObject.containsKey((Object)"name")) {
            this.name = JSONUtils.getString(jsonObject, "name");
        }
    }

    private ConfigValidationResult restoreValidationResult(JSONObject item) {
        ConfigValidationResult result = new ConfigValidationResult();
        Set entrySet = item.entrySet();
        for (Map.Entry entry : entrySet) {
            result.addMessages((String)entry.getKey(), this.restoreMessageList((JSONArray)entry.getValue()));
        }
        return result;
    }

    private List<Message> restoreMessageList(JSONArray array) {
        LinkedList<Message> messages = new LinkedList<Message>();
        for (Object item : array) {
            messages.add(this.restoreMessage((JSONObject)item));
        }
        return messages;
    }

    private Message restoreMessage(JSONObject item) {
        return new Message(Status.valueOf(JSONUtils.getString(item, STATUS)), JSONUtils.getString(item, MESSAGE));
    }
}

